/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.kogito.codegen.metadata.ImageMetaData;

public class ImageMetaDataTest {
    @Test
    public void getSetLabels() {
        ImageMetaData imageMetaData = new ImageMetaData();
        ArrayList labels = new ArrayList();
        HashMap<String, String> firstLabels = new HashMap<String, String>();
        firstLabels.put("firstLabelsKey1", "firstLabelsValue1");
        HashMap<String, String> secondLabels = new HashMap<String, String>();
        secondLabels.put("secondLabelsKey1", "secondLabelsValue1");
        labels.add(firstLabels);
        labels.add(secondLabels);
        imageMetaData.setLabels(labels);
        Assertions.assertThat((List)imageMetaData.getLabels()).isSameAs(labels);
        Assertions.assertThat((List)imageMetaData.getLabels()).containsExactlyInAnyOrder((Object[])new Map[]{firstLabels, secondLabels});
    }

    @Test
    public void getSetLabelsNull() {
        ImageMetaData imageMetaData = new ImageMetaData();
        imageMetaData.setLabels(null);
        Assertions.assertThat((List)imageMetaData.getLabels()).isNull();
    }

    @Test
    public void add() {
        ImageMetaData imageMetaData = new ImageMetaData();
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("firstLabelsKey1", "firstLabelsValue1");
        imageMetaData.add(labels);
        HashMap<String, String> secondLabels = new HashMap<String, String>();
        secondLabels.put("secondLabelsKey1", "secondLabelsValue1");
        imageMetaData.add(secondLabels);
        Assertions.assertThat((List)imageMetaData.getLabels()).isNotNull();
        Assertions.assertThat((List)imageMetaData.getLabels()).hasSize(1);
        labels.putAll(secondLabels);
        Assertions.assertThat((Map)((Map)imageMetaData.getLabels().get(0))).hasSize(2);
        Assertions.assertThat((Map)((Map)imageMetaData.getLabels().get(0))).containsAllEntriesOf(labels);
    }
}

