/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.metadata;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.metadata.PersistenceProtoFilesLabeler;

public class PersistenceProtoFilesLabelerTest {
    @Test
    void testGenerateLabels() throws URISyntaxException, IOException {
        PersistenceProtoFilesLabeler labeler = new PersistenceProtoFilesLabeler();
        File protoFile = new File(this.getClass().getResource("/kogito-types.proto").toURI());
        File kogitoApplication = new File(this.getClass().getResource("/kogito-application.proto").toURI());
        Assertions.assertThat((File)protoFile).isNotNull();
        Assertions.assertThat((File)kogitoApplication).isNotNull();
        labeler.processProto(protoFile);
        labeler.processProto(kogitoApplication);
        Map labels = labeler.generateLabels();
        Assertions.assertThat((Map)labels).size().isEqualTo(1);
        Assertions.assertThat((Map)labels).containsKey((Object)labeler.generateKey(protoFile));
        byte[] bytes = Base64.getDecoder().decode((String)labels.get("org.kie/persistence/proto/kogito-types.proto"));
        Assertions.assertThat((byte[])bytes).hasSize(229);
    }

    @Test
    void testGenerateLabelsIOException() throws URISyntaxException {
        PersistenceProtoFilesLabeler labeler = new PersistenceProtoFilesLabeler();
        org.junit.jupiter.api.Assertions.assertThrows(UncheckedIOException.class, () -> labeler.processProto(new File("/does/not/exist")));
    }
}

