/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.jbpm.workflow.core.node.Trigger;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.kogito.Application;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.process.ProcessCodegen;
import org.kie.kogito.codegen.process.ProcessCodegenException;
import org.kie.kogito.process.impl.AbstractProcess;

public class ProcessGenerationTest
extends AbstractCodegenTest {
    private static final Collection<String> IGNORED_PROCESS_META = Arrays.asList("Definitions", "BPMN.Connections", "ItemDefinitions");
    private static final Path BASE_PATH = Paths.get("src/test/resources", new String[0]);
    private static final BiConsumer<Node, Node> nodeAsserter = (expected, current) -> {
        Assertions.assertEquals((long)expected.getId(), (long)current.getId());
        if (expected.getName() != null) {
            Assertions.assertEquals((Object)expected.getName(), (Object)current.getName());
        } else {
            Assertions.assertNotNull((Object)current.getName(), (String)current.getClass().getName());
        }
        ProcessGenerationTest.assertConnections(expected.getIncomingConnections(), current.getIncomingConnections());
        ProcessGenerationTest.assertConnections(expected.getOutgoingConnections(), current.getOutgoingConnections());
        ProcessGenerationTest.assertConstraints((NodeImpl)expected, (NodeImpl)current);
    };
    private static final BiConsumer<Node, Node> extendedNodeAsserter = (eNode, cNode) -> {
        Assertions.assertTrue((boolean)ExtendedNodeImpl.class.isAssignableFrom(eNode.getClass()));
        Assertions.assertTrue((boolean)ExtendedNodeImpl.class.isAssignableFrom(cNode.getClass()));
        ExtendedNodeImpl expected = (ExtendedNodeImpl)eNode;
        ExtendedNodeImpl current = (ExtendedNodeImpl)cNode;
        ProcessGenerationTest.assertActions(eNode, expected, current);
    };
    private static final BiConsumer<Node, Node> startNodeAsserter = (eNode, cNode) -> {
        Assertions.assertEquals(StartNode.class, eNode.getClass());
        Assertions.assertEquals(StartNode.class, cNode.getClass());
        StartNode expected = (StartNode)eNode;
        StartNode current = (StartNode)cNode;
        Assertions.assertEquals((Object)expected.isInterrupting(), (Object)current.isInterrupting(), (String)"Interrupting");
        ProcessGenerationTest.assertTriggers(expected.getTriggers(), current.getTriggers());
    };
    private static final BiConsumer<Node, Node> endNodeAsserter = (eNode, cNode) -> {
        Assertions.assertEquals(EndNode.class, eNode.getClass());
        Assertions.assertEquals(EndNode.class, cNode.getClass());
        EndNode expected = (EndNode)eNode;
        EndNode current = (EndNode)cNode;
        Assertions.assertEquals((Object)expected.isTerminate(), (Object)current.isTerminate(), (String)"Terminate");
    };
    private static final BiConsumer<Node, Node> stateBasedNodeAsserter = (eNode, cNode) -> {
        Assertions.assertTrue((boolean)StateBasedNode.class.isAssignableFrom(eNode.getClass()));
        Assertions.assertTrue((boolean)StateBasedNode.class.isAssignableFrom(cNode.getClass()));
        StateBasedNode expected = (StateBasedNode)eNode;
        StateBasedNode current = (StateBasedNode)cNode;
        Assertions.assertEquals((Object)expected.getBoundaryEvents(), (Object)current.getBoundaryEvents(), (String)"BoundaryEvents");
        ProcessGenerationTest.assertTimers(expected.getTimers(), current.getTimers());
    };
    private static final BiConsumer<Node, Node> workItemNodeAsserter = (eNode, cNode) -> {
        Assertions.assertTrue((boolean)WorkItemNode.class.isAssignableFrom(eNode.getClass()));
        Assertions.assertTrue((boolean)WorkItemNode.class.isAssignableFrom(cNode.getClass()));
        WorkItemNode expected = (WorkItemNode)eNode;
        WorkItemNode current = (WorkItemNode)cNode;
        Assertions.assertEquals((Object)expected.isWaitForCompletion(), (Object)current.isWaitForCompletion(), (String)"WaitForCompletion");
        Assertions.assertEquals((int)expected.getInMappings().size(), (int)current.getInMappings().size(), (String)"inMappings");
        expected.getInMappings().forEach((k, v) -> Assertions.assertEquals((Object)v, (Object)current.getInMapping(k), (String)("inMapping " + k)));
        Assertions.assertEquals((int)expected.getOutMappings().size(), (int)current.getOutMappings().size(), (String)"outMappings");
        expected.getOutMappings().forEach((k, v) -> Assertions.assertEquals((Object)v, (Object)current.getOutMapping(k), (String)("outMapping " + k)));
    };
    private static final BiConsumer<Node, Node> humanTaskNodeAsserter = (eNode, cNode) -> {
        Assertions.assertEquals(HumanTaskNode.class, eNode.getClass());
        Assertions.assertEquals(HumanTaskNode.class, cNode.getClass());
        HumanTaskNode expected = (HumanTaskNode)eNode;
        HumanTaskNode current = (HumanTaskNode)cNode;
        Assertions.assertEquals((Object)expected.getSwimlane(), (Object)current.getSwimlane(), (String)"Swimlane");
    };
    private static final BiConsumer<Node, Node> eventNodeAsserter = (eNode, cNode) -> {
        Assertions.assertTrue((boolean)EventNode.class.isAssignableFrom(eNode.getClass()));
        Assertions.assertTrue((boolean)EventNode.class.isAssignableFrom(cNode.getClass()));
        EventNode expected = (EventNode)eNode;
        EventNode current = (EventNode)cNode;
        Assertions.assertEquals((Object)expected.getScope(), (Object)current.getScope(), (String)"Scope");
        Assertions.assertEquals((Object)expected.getType(), (Object)current.getType(), (String)"Type");
        Assertions.assertEquals((Object)expected.getVariableName(), (Object)current.getVariableName(), (String)"VariableName");
        Assertions.assertEquals((int)expected.getEventFilters().size(), (int)current.getEventFilters().size(), (String)"EventFilters");
    };
    private static final BiConsumer<Node, Node> boundaryEventNodeAsserter = (eNode, cNode) -> {
        Assertions.assertEquals(BoundaryEventNode.class, eNode.getClass());
        Assertions.assertEquals(BoundaryEventNode.class, cNode.getClass());
        BoundaryEventNode expected = (BoundaryEventNode)eNode;
        BoundaryEventNode current = (BoundaryEventNode)cNode;
        Assertions.assertEquals((Object)expected.getAttachedToNodeId(), (Object)current.getAttachedToNodeId(), (String)"AttachedToNodeId");
    };
    private static final BiConsumer<Node, Node> splitNodeAsserter = (eNode, cNode) -> {
        Assertions.assertEquals(Split.class, eNode.getClass());
        Assertions.assertEquals(Split.class, cNode.getClass());
        Split expected = (Split)eNode;
        Split current = (Split)cNode;
        Assertions.assertEquals((int)expected.getType(), (int)current.getType(), (String)"Type");
    };
    private static final BiConsumer<Node, Node> joinNodeAsserter = (eNode, cNode) -> {
        Assertions.assertEquals(Join.class, eNode.getClass());
        Assertions.assertEquals(Join.class, cNode.getClass());
        Join expected = (Join)eNode;
        Join current = (Join)cNode;
        Assertions.assertEquals((int)expected.getType(), (int)current.getType(), (String)"Type");
        Assertions.assertEquals((Object)expected.getN(), (Object)current.getN(), (String)"N");
    };
    private static final BiConsumer<Node, Node> actionNodeAsserter = (eNode, cNode) -> {
        Assertions.assertEquals(ActionNode.class, eNode.getClass());
        Assertions.assertEquals(ActionNode.class, cNode.getClass());
        ActionNode expected = (ActionNode)eNode;
        ActionNode current = (ActionNode)cNode;
        if (expected.getAction() != null) {
            Assertions.assertNotNull((Object)current.getAction());
            Assertions.assertEquals((Object)expected.getAction().getName(), (Object)current.getAction().getName(), (String)"Action");
        }
    };
    private static final BiConsumer<Node, Node> milestoneNodeAsserter = (eNode, cNode) -> {
        Assertions.assertEquals(MilestoneNode.class, eNode.getClass());
        Assertions.assertEquals(MilestoneNode.class, cNode.getClass());
        MilestoneNode expected = (MilestoneNode)eNode;
        MilestoneNode current = (MilestoneNode)cNode;
        Assertions.assertEquals((Object)expected.getConstraint(), (Object)current.getConstraint(), (String)"Constraint");
        Assertions.assertEquals((Object)expected.getMatchVariable(), (Object)current.getMatchVariable(), (String)"MatchVariable");
    };
    private static final BiConsumer<Node, Node> compositeNodeAsserter = (eNode, cNode) -> {
        Assertions.assertTrue((boolean)CompositeNode.class.isAssignableFrom(eNode.getClass()));
        Assertions.assertTrue((boolean)CompositeNode.class.isAssignableFrom(cNode.getClass()));
        CompositeNode expected = (CompositeNode)eNode;
        CompositeNode current = (CompositeNode)cNode;
        ProcessGenerationTest.assertNodes(expected.getNodes(), current.getNodes());
    };
    private static final Map<Class<? extends Node>, BiConsumer<Node, Node>> nodeAsserters = new HashMap<Class<? extends Node>, BiConsumer<Node, Node>>();

    static Stream<String> processesProvider() throws IOException {
        Set ignoredFiles = Files.lines(BASE_PATH.resolve("org/kie/kogito/codegen/process/process-generation-test.skip.txt")).collect(Collectors.toSet());
        return Files.find(BASE_PATH, 10, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && (ProcessCodegen.SUPPORTED_BPMN_EXTENSIONS.stream().anyMatch(ext -> path.getFileName().toString().endsWith((String)ext)) || ProcessCodegen.SUPPORTED_SW_EXTENSIONS.keySet().stream().anyMatch(ext -> path.getFileName().toString().endsWith((String)ext))), new FileVisitOption[0]).map(BASE_PATH::relativize).map(Path::toString).filter(p -> !ignoredFiles.contains(p));
    }

    @ParameterizedTest
    @MethodSource(value={"processesProvider"})
    public void testProcessGeneration(String processFile) throws Exception {
        List processes = ProcessCodegen.parseProcesses((Collection)Stream.of(processFile).map(resource -> new File(BASE_PATH.toString(), (String)resource)).collect(Collectors.toList()));
        RuleFlowProcess expected = (RuleFlowProcess)processes.get(0);
        Application app = this.generateCodeProcessesOnly(processFile);
        AbstractProcess process = (AbstractProcess)app.processes().processById(expected.getId());
        RuleFlowProcess current = (RuleFlowProcess)process.legacyProcess();
        Assertions.assertNotNull((Object)current);
        Assertions.assertEquals((Object)expected.getId(), (Object)current.getId(), (String)"Id");
        Assertions.assertEquals((Object)expected.getName(), (Object)current.getName(), (String)"Name");
        Assertions.assertEquals((Object)expected.getPackageName(), (Object)current.getPackageName(), (String)"PackageName");
        Assertions.assertEquals((Object)expected.getVisibility(), (Object)current.getVisibility(), (String)"Visibility");
        Assertions.assertEquals((Object)expected.getType(), (Object)current.getType(), (String)"Type");
        Assertions.assertEquals((Object)expected.isAutoComplete(), (Object)current.isAutoComplete(), (String)"AutoComplete");
        Assertions.assertEquals((Object)expected.isDynamic(), (Object)current.isDynamic(), (String)"Dynamic");
        if (expected.getVersion() != null) {
            Assertions.assertEquals((Object)expected.getVersion(), (Object)current.getVersion());
        } else {
            Assertions.assertEquals((Object)"1.0", (Object)current.getVersion());
        }
        Assertions.assertEquals((Object)expected.getImports(), (Object)current.getImports(), (String)"Imports");
        Assertions.assertEquals((Object)expected.getFunctionImports(), (Object)current.getFunctionImports(), (String)"FunctionImports");
        ProcessGenerationTest.assertMetadata(expected.getMetaData(), current.getMetaData(), IGNORED_PROCESS_META);
        ProcessGenerationTest.assertNodes(expected.getNodes(), current.getNodes());
    }

    @Test
    public void testInvalidProcess() throws Exception {
        try {
            this.testProcessGeneration("messageevent/EventNodeMalformed.bpmn2");
            Assertions.fail((String)"Expected ProcessCodegenException");
        }
        catch (ProcessCodegenException e) {
            Assertions.assertNotNull((Object)((Object)e));
        }
    }

    private static void assertNodes(Node[] expected, Node[] current) {
        Assertions.assertEquals((int)expected.length, (int)current.length);
        Stream.of(expected).forEach(eNode -> {
            Optional<Node> cNode = Stream.of(current).filter(c -> c.getId() == eNode.getId()).findFirst();
            Assertions.assertTrue((boolean)cNode.isPresent(), (String)("Missing node " + eNode.getName()));
            ProcessGenerationTest.assertNode(eNode, cNode.get());
        });
    }

    private static void assertActions(Node eNode, ExtendedNodeImpl expected, ExtendedNodeImpl current) {
        for (String actionType : expected.getActionTypes()) {
            ArrayList<DroolsAction> expectedActions = expected.getActions(actionType);
            if (eNode instanceof EndNode && expected.getMetaData("TriggerRef") != null) {
                if (expectedActions == null) {
                    expectedActions = new ArrayList<DroolsAction>();
                }
                expectedActions.add(new DroolsAction());
            }
            try {
                if (expected.getActions(actionType) == null) {
                    Assertions.assertNull((Object)current.getActions(actionType));
                    continue;
                }
                Assertions.assertNotNull((Object)current.getActions(actionType));
            }
            catch (Throwable e) {
                Assertions.fail((String)("Actions are not equal for type: " + actionType), (Throwable)e);
            }
        }
    }

    private static void assertNode(Node expected, Node current) {
        nodeAsserters.keySet().stream().filter(clazz -> clazz.isAssignableFrom(expected.getClass())).forEach(clazz -> {
            try {
                nodeAsserters.get(clazz).accept(expected, current);
            }
            catch (Throwable e) {
                Assertions.fail((String)String.format("[%s] nodes with name [%s] are not equal", expected.getClass().getSimpleName(), current.getName()), (Throwable)e);
            }
        });
    }

    private static void assertMetadata(Map<String, Object> expected, Map<String, Object> current, Collection<String> ignoredKeys) {
        if (expected == null) {
            Assertions.assertNull(current);
            return;
        }
        Assertions.assertNotNull(current);
        Assertions.assertEquals((long)expected.keySet().stream().filter(k -> ignoredKeys == null || !ignoredKeys.contains(k)).count(), (long)current.size());
        expected.keySet().stream().filter(k -> ignoredKeys == null || !ignoredKeys.contains(k)).forEach(k -> Assertions.assertEquals(expected.get(k), current.get(k), (String)("Metadata " + k)));
    }

    private static void assertConnections(Map<String, List<Connection>> expectedConnections, Map<String, List<Connection>> currentConnections) {
        Assertions.assertEquals((int)expectedConnections.size(), (int)currentConnections.size());
        expectedConnections.forEach((type, expectedByType) -> {
            Assertions.assertTrue((boolean)currentConnections.containsKey(type), (String)("Node does not have connections of type: " + type));
            List currentByType = (List)currentConnections.get(type);
            expectedByType.forEach(expected -> {
                Optional<Connection> current = currentByType.stream().filter(c -> expected.getMetaData().isEmpty() || expected.getMetaData().get("UniqueId").equals(c.getMetaData().get("UniqueId"))).findFirst();
                Assertions.assertTrue((boolean)current.isPresent(), (String)("Connection is present for " + expected.getMetaData().get("UniqueId")));
                Assertions.assertEquals((Object)expected.getFromType(), (Object)current.get().getFromType(), (String)"FromType");
                Assertions.assertEquals((long)expected.getFrom().getId(), (long)current.get().getFrom().getId(), (String)"From.Id");
                Assertions.assertEquals((Object)expected.getToType(), (Object)current.get().getToType(), (String)"ToType");
                Assertions.assertEquals((long)expected.getTo().getId(), (long)current.get().getTo().getId(), (String)"To.Id");
            });
        });
    }

    private static void assertTriggers(List<Trigger> expected, List<Trigger> current) {
        try {
            if (expected == null) {
                Assertions.assertNull(current);
                return;
            }
            Assertions.assertNotNull(current);
            Assertions.assertEquals((int)expected.size(), (int)current.size());
            for (int i = 0; i < expected.size(); ++i) {
                Trigger e = expected.get(i);
                Trigger c = current.get(i);
                e.getInMappings().forEach((k, v) -> Assertions.assertEquals((Object)v, (Object)c.getInMapping(k), (String)("InMapping for " + k)));
                ProcessGenerationTest.assertDataAssociations(e.getInAssociations(), c.getInAssociations());
            }
        }
        catch (Throwable e) {
            Assertions.fail((String)"Triggers are not equal", (Throwable)e);
        }
    }

    private static void assertDataAssociations(List<DataAssociation> expected, List<DataAssociation> current) {
        if (expected == null) {
            Assertions.assertNull(current);
            return;
        }
        if (expected.isEmpty()) {
            Assertions.assertEquals((int)1, (int)current.size());
            Assertions.assertEquals((int)1, (int)current.get(0).getSources().size());
            Assertions.assertEquals((Object)"", current.get(0).getSources().get(0));
        } else {
            Assertions.assertEquals((int)expected.size(), (int)current.size());
            for (int i = 0; i < expected.size(); ++i) {
                Assertions.assertEquals((Object)expected.get(i).getSources(), (Object)current.get(i).getSources(), (String)"Sources");
                Assertions.assertEquals((Object)expected.get(i).getTarget(), (Object)current.get(i).getTarget(), (String)"Target");
                Assertions.assertEquals((Object)expected.get(i).getTransformation(), (Object)current.get(i).getTransformation(), (String)"Transformation");
                ProcessGenerationTest.assertAssignments(expected.get(i).getAssignments(), current.get(i).getAssignments());
            }
        }
    }

    private static void assertAssignments(List<Assignment> expected, List<Assignment> current) {
        if (expected == null) {
            Assertions.assertNull(current);
            return;
        }
        Assertions.assertEquals((int)expected.size(), (int)current.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assertions.assertEquals((Object)expected.get(i).getFrom(), (Object)current.get(i).getFrom(), (String)"From");
            Assertions.assertEquals((Object)expected.get(i).getDialect(), (Object)current.get(i).getDialect(), (String)"Dialect");
            Assertions.assertEquals((Object)expected.get(i).getTo(), (Object)current.get(i).getTo(), (String)"To");
        }
    }

    private static void assertTimers(Map<Timer, DroolsAction> expected, Map<Timer, DroolsAction> current) {
        if (expected == null) {
            Assertions.assertNull(current);
            return;
        }
        Assertions.assertNotNull(current);
        Assertions.assertEquals((int)expected.size(), (int)current.size(), (String)"Size");
        expected.forEach((expectedTimer, expectedAction) -> {
            Optional<Timer> currentTimer = current.keySet().stream().filter(c -> c.getId() == expectedTimer.getId()).findFirst();
            Assertions.assertTrue((boolean)currentTimer.isPresent());
            Assertions.assertEquals((Object)expectedTimer.getPeriod(), (Object)currentTimer.get().getPeriod(), (String)"Period");
            Assertions.assertEquals((Object)expectedTimer.getDate(), (Object)currentTimer.get().getDate(), (String)"Date");
            Assertions.assertEquals((Object)expectedTimer.getDelay(), (Object)currentTimer.get().getDelay(), (String)"Delay");
            Assertions.assertEquals((int)expectedTimer.getTimeType(), (int)currentTimer.get().getTimeType(), (String)"TimeType");
            DroolsAction currentAction = (DroolsAction)current.get(currentTimer.get());
            if (expectedAction == null) {
                Assertions.assertNull((Object)currentAction);
                return;
            }
            Assertions.assertNotNull((Object)currentAction);
            Assertions.assertEquals((Object)expectedAction.getName(), (Object)currentAction.getName(), (String)"DroolsAction name");
            if (expectedAction.getMetaData("Action") == null) {
                Assertions.assertNull((Object)currentAction.getMetaData("Action"));
            } else {
                Assertions.assertNotNull((Object)currentAction.getMetaData("Action"));
            }
        });
    }

    private static void assertConstraints(NodeImpl eNode, NodeImpl cNode) {
        if (eNode instanceof Split && ((Split)eNode).getType() != 3 && ((Split)eNode).getType() != 2) {
            return;
        }
        if (eNode.getConstraints() == null) {
            Assertions.assertNull((Object)cNode.getConstraints());
            return;
        }
        Map expected = eNode.getConstraints();
        Map current = cNode.getConstraints();
        Assertions.assertEquals((int)expected.size(), (int)current.size());
        expected.forEach((conn, constraint) -> {
            Optional<Map.Entry> currentEntry = current.entrySet().stream().filter(e -> ((ConnectionRef)e.getKey()).getConnectionId().equals(conn.getConnectionId())).findFirst();
            Assertions.assertTrue((boolean)currentEntry.isPresent());
            ConnectionRef currentConn = (ConnectionRef)currentEntry.get().getKey();
            Assertions.assertEquals((long)conn.getNodeId(), (long)currentConn.getNodeId());
            Assertions.assertEquals((Object)conn.getToType(), (Object)currentConn.getToType());
            Constraint currentConstraint = (Constraint)currentEntry.get().getValue();
            if (constraint == null) {
                Assertions.assertNull((Object)currentConstraint);
            } else {
                Assertions.assertNotNull((Object)currentConstraint);
                Assertions.assertEquals((int)constraint.getPriority(), (int)currentConstraint.getPriority());
                Assertions.assertEquals((Object)constraint.getDialect(), (Object)currentConstraint.getDialect());
                Assertions.assertEquals((Object)conn.getConnectionId(), (Object)currentConstraint.getName());
                Assertions.assertEquals((Object)"DROOLS_DEFAULT", (Object)currentConstraint.getType());
            }
        });
    }

    static {
        nodeAsserters.put(NodeImpl.class, nodeAsserter);
        nodeAsserters.put(ExtendedNodeImpl.class, extendedNodeAsserter);
        nodeAsserters.put(StartNode.class, startNodeAsserter);
        nodeAsserters.put(EndNode.class, endNodeAsserter);
        nodeAsserters.put(Split.class, splitNodeAsserter);
        nodeAsserters.put(Join.class, joinNodeAsserter);
        nodeAsserters.put(StateBasedNode.class, stateBasedNodeAsserter);
        nodeAsserters.put(WorkItemNode.class, workItemNodeAsserter);
        nodeAsserters.put(HumanTaskNode.class, humanTaskNodeAsserter);
        nodeAsserters.put(EventNode.class, eventNodeAsserter);
        nodeAsserters.put(BoundaryEventNode.class, boundaryEventNodeAsserter);
        nodeAsserters.put(ActionNode.class, actionNodeAsserter);
        nodeAsserters.put(MilestoneNode.class, milestoneNodeAsserter);
        nodeAsserters.put(CompositeNode.class, compositeNodeAsserter);
    }
}

