/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.config.DefaultRuleEventListenerConfig;
import org.drools.core.event.DefaultAgendaEventListener;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.process.ProcessCodegenException;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;
import org.kie.kogito.rules.units.UndefinedGeneratedRuleUnitVariable;
import org.kie.kogito.uow.UnitOfWork;

public class BusinessRuleUnitTest
extends AbstractCodegenTest {
    static Stream<String> processes() {
        return Stream.of("org/kie/kogito/codegen/tests/BusinessRuleUnit.bpmn2", "org/kie/kogito/codegen/tests/BusinessRuleUnitAlternateSyntax.bpmn2");
    }

    @ParameterizedTest
    @MethodSource(value={"processes"})
    public void testBasicBusinessRuleUnit(String bpmnPath) throws Exception {
        Application app = this.generateCode(Collections.singletonList(bpmnPath), Collections.singletonList("org/kie/kogito/codegen/tests/BusinessRuleUnit.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("BusinessRuleUnit");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
    }

    @ParameterizedTest
    @MethodSource(value={"processes"})
    public void testBasicBusinessRuleUnitWithAgendaListener(String bpmnPath) throws Exception {
        Application app = this.generateCode(Collections.singletonList(bpmnPath), Collections.singletonList("org/kie/kogito/codegen/tests/BusinessRuleUnit.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        final AtomicInteger counter = new AtomicInteger();
        ((DefaultRuleEventListenerConfig)app.config().rule().ruleEventListeners()).register((AgendaEventListener)new DefaultAgendaEventListener(){

            public void afterMatchFired(AfterMatchFiredEvent event) {
                counter.incrementAndGet();
            }
        });
        Process p = app.processes().processById("BusinessRuleUnit");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
        Assertions.assertThat((int)counter.get()).isEqualTo(1);
    }

    @ParameterizedTest
    @MethodSource(value={"processes"})
    public void testBasicBusinessRuleUnitControlledByUnitOfWork(String bpmnPath) throws Exception {
        Application app = this.generateCode(Collections.singletonList(bpmnPath), Collections.singletonList("org/kie/kogito/codegen/tests/BusinessRuleUnit.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        final ArrayList startedProcesses = new ArrayList();
        ((DefaultProcessEventListenerConfig)app.config().process().processEventListeners()).listeners().add(new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                startedProcesses.add(event.getProcessInstance().getId());
            }
        });
        UnitOfWork uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        Process p = app.processes().processById("BusinessRuleUnit");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
        Assertions.assertThat(startedProcesses).hasSize(0);
        uow.end();
        Assertions.assertThat(startedProcesses).hasSize(1);
    }

    @Test
    public void ioMapping() throws Exception {
        Application app = this.generateCode(Collections.singletonList("ruletask/ExampleP.bpmn"), Collections.singletonList("ruletask/Example.drl"));
        Process process = app.processes().processById("ruletask.ExampleP");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("singleString", "hello");
        map.put("singlePerson", new Person("Yoko", 86));
        map.put("manyPersons", Arrays.asList(new Person("Paul", 77), new Person("Ringo", 79)));
        map.put("emptyList", new ArrayList());
        Model model = (Model)process.createModel();
        model.fromMap(map);
        ProcessInstance instance = process.createInstance(model);
        Model variables = (Model)instance.variables();
        Map result = variables.toMap();
        org.junit.jupiter.api.Assertions.assertNull(result.get("emptyString"));
        org.junit.jupiter.api.Assertions.assertNull(result.get("emptyPerson"));
        Assertions.assertThat((Iterable)((Collection)result.get("emptyList"))).isEmpty();
        instance.start();
        result = ((Model)instance.variables()).toMap();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", result.get("emptyString"));
        Person yoko = new Person("Yoko", 86);
        yoko.setAdult(true);
        org.junit.jupiter.api.Assertions.assertEquals((Object)yoko, result.get("emptyPerson"));
        Person paul = new Person("Paul", 77);
        paul.setAdult(true);
        Person ringo = new Person("Ringo", 79);
        ringo.setAdult(true);
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(paul, ringo), result.get("emptyList"));
    }

    @Test
    public void ioMappingAutoGeneratedRuleUnit() throws Exception {
        Application app = this.generateCode(Collections.singletonList("ruletask/ExampleGenerated.bpmn"), Collections.singletonList("ruletask/Generated.drl"));
        Process process = app.processes().processById("ruletask.ExampleGenerated");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("singleString", "hello");
        map.put("singlePerson", new Person("Yoko", 86));
        map.put("manyPersons", Arrays.asList(new Person("Paul", 77), new Person("Ringo", 79)));
        map.put("emptyList", new ArrayList());
        Model model = (Model)process.createModel();
        model.fromMap(map);
        ProcessInstance instance = process.createInstance(model);
        Model variables = (Model)instance.variables();
        Map result = variables.toMap();
        org.junit.jupiter.api.Assertions.assertNull(result.get("emptyString"));
        org.junit.jupiter.api.Assertions.assertNull(result.get("emptyPerson"));
        instance.start();
        result = ((Model)instance.variables()).toMap();
        Person yoko = new Person("Yoko", 86);
        yoko.setAdult(true);
        org.junit.jupiter.api.Assertions.assertEquals((Object)yoko, result.get("singlePerson"));
    }

    @Test
    public void testSettingOtherVariableFromAutoGeneratedRuleUnit() throws Exception {
        Application app = this.generateCode(Collections.singletonList("ruletask/ExampleGenerated.bpmn"), Collections.singletonList("ruletask/Generated.drl"));
        Process process = app.processes().processById("ruletask.ExampleGenerated");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("singleString", "hello");
        map.put("singlePerson", new Person("John", 50));
        Model model = (Model)process.createModel();
        model.fromMap(map);
        ProcessInstance instance = process.createInstance(model);
        Model variables = (Model)instance.variables();
        Map result = variables.toMap();
        org.junit.jupiter.api.Assertions.assertNull(result.get("emptyString"));
        org.junit.jupiter.api.Assertions.assertNull(result.get("emptyPerson"));
        instance.start();
        result = ((Model)instance.variables()).toMap();
        Person john = new Person("John", 50);
        john.setAdult(true);
        org.junit.jupiter.api.Assertions.assertEquals((Object)john, result.get("singlePerson"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Now the life starts again", result.get("singleString"));
    }

    @Test
    public void testRemovingOtherVariableFromAutoGeneratedRuleUnit() throws Exception {
        Application app = this.generateCode(Collections.singletonList("ruletask/ExampleGenerated.bpmn"), Collections.singletonList("ruletask/Generated.drl"));
        Process process = app.processes().processById("ruletask.ExampleGenerated");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("singleString", "hello");
        map.put("singlePerson", new Person("John", 60));
        Model model = (Model)process.createModel();
        model.fromMap(map);
        ProcessInstance instance = process.createInstance(model);
        Model variables = (Model)instance.variables();
        Map result = variables.toMap();
        org.junit.jupiter.api.Assertions.assertNull(result.get("emptyString"));
        org.junit.jupiter.api.Assertions.assertNull(result.get("emptyPerson"));
        instance.start();
        result = ((Model)instance.variables()).toMap();
        Person john = new Person("John", 60);
        john.setAdult(true);
        org.junit.jupiter.api.Assertions.assertEquals((Object)john, result.get("singlePerson"));
        org.junit.jupiter.api.Assertions.assertNull(result.get("singleString"));
    }

    @Test
    public void wrongVariableNameInGeneratedRuleUnit() {
        Assertions.assertThatExceptionOfType(ProcessCodegenException.class).isThrownBy(() -> {
            Application app = this.generateCode(Collections.singletonList("ruletask/ExampleGeneratedWrong.bpmn"), Collections.singletonList("ruletask/Generated.drl"));
        }).withCauseInstanceOf(UndefinedGeneratedRuleUnitVariable.class);
    }

    @Test
    @DisplayName(value="Should throw an exception when a null collection variable is mapped as input of a datasource")
    public void inputMappingNullCollection() throws Exception {
        Application app = this.generateCode(Collections.singletonList("ruletask/ExampleP.bpmn"), Collections.singletonList("ruletask/Example.drl"));
        Process process = app.processes().processById("ruletask.ExampleP");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("singleString", "hello");
        map.put("singlePerson", new Person("Yoko", 86));
        map.put("manyPersons", null);
        Model model = (Model)process.createModel();
        model.fromMap(map);
        ProcessInstance instance = process.createInstance(model);
        Model variables = (Model)instance.variables();
        Map result = variables.toMap();
        org.junit.jupiter.api.Assertions.assertNull(result.get("emptyString"));
        org.junit.jupiter.api.Assertions.assertNull(result.get("emptyPerson"));
        org.junit.jupiter.api.Assertions.assertNull(result.get("emptyList"));
        instance.start();
        Assertions.assertThat((int)instance.status()).isEqualTo(5);
        Assertions.assertThat((String)((ProcessError)instance.error().get()).errorMessage()).contains(new CharSequence[]{"The input collection variable of a data source cannot be null"});
    }

    @Test
    @DisplayName(value="Should throw an exception when a null collection variable is mapped as output of a datasource")
    public void outputMappingNullCollection() throws Exception {
        Application app = this.generateCode(Collections.singletonList("ruletask/ExampleP.bpmn"), Collections.singletonList("ruletask/Example.drl"));
        Process process = app.processes().processById("ruletask.ExampleP");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("singleString", "hello");
        map.put("singlePerson", new Person("Yoko", 86));
        map.put("manyPersons", Arrays.asList(new Person("Paul", 77), new Person("Ringo", 79)));
        Model model = (Model)process.createModel();
        model.fromMap(map);
        ProcessInstance instance = process.createInstance(model);
        Model variables = (Model)instance.variables();
        Map result = variables.toMap();
        org.junit.jupiter.api.Assertions.assertNull(result.get("emptyString"));
        org.junit.jupiter.api.Assertions.assertNull(result.get("emptyPerson"));
        org.junit.jupiter.api.Assertions.assertNull(result.get("emptyList"));
        instance.start();
        Assertions.assertThat((int)instance.status()).isEqualTo(5);
        Assertions.assertThat((String)((ProcessError)instance.error().get()).errorMessage()).contains(new CharSequence[]{"Null collection variable used as an output variable"});
    }

    @Test
    public void malformedShouldThrowException() {
        org.junit.jupiter.api.Assertions.assertThrows(ProcessCodegenException.class, () -> this.generateCodeProcessesOnly("ruletask/BusinessRuleTaskMalformed.bpmn2"));
    }
}

