/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.event.ProcessInstanceDataEvent;
import org.kie.kogito.services.event.UserTaskInstanceDataEvent;
import org.kie.kogito.services.event.VariableInstanceDataEvent;
import org.kie.kogito.services.event.impl.ProcessInstanceEventBody;
import org.kie.kogito.services.event.impl.UserTaskInstanceEventBody;
import org.kie.kogito.services.event.impl.VariableInstanceEventBody;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.uow.UnitOfWork;

public class PublishEventTest
extends AbstractCodegenTest {
    @Test
    public void testBusinessRuleProcessStartToEnd() throws Exception {
        Application app = this.generateCode(Collections.singletonList("ruletask/BusinessRuleTask.bpmn2"), Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        TestEventPublisher publisher = new TestEventPublisher();
        app.unitOfWorkManager().eventManager().setService("http://myhost");
        app.unitOfWorkManager().eventManager().addPublisher((EventPublisher)publisher);
        UnitOfWork uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        Process p = app.processes().processById("BusinessRuleTask");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
        uow.end();
        List<DataEvent<?>> events = publisher.extract();
        ((ListAssert)Assertions.assertThat(events).isNotNull()).hasSize(1);
        DataEvent<?> event = events.get(0);
        Assertions.assertThat(event).isInstanceOf(ProcessInstanceDataEvent.class);
        ProcessInstanceDataEvent processDataEvent = (ProcessInstanceDataEvent)event;
        Assertions.assertThat((String)processDataEvent.getKogitoProcessinstanceId()).isNotNull();
        Assertions.assertThat((String)processDataEvent.getKogitoParentProcessinstanceId()).isNull();
        Assertions.assertThat((String)processDataEvent.getKogitoRootProcessinstanceId()).isNull();
        Assertions.assertThat((String)processDataEvent.getKogitoProcessId()).isEqualTo("BusinessRuleTask");
        Assertions.assertThat((String)processDataEvent.getKogitoProcessinstanceState()).isEqualTo("2");
        Assertions.assertThat((String)processDataEvent.getSource()).isEqualTo("http://myhost/BusinessRuleTask");
        ProcessInstanceEventBody body = this.assertProcessInstanceEvent(events.get(0), "BusinessRuleTask", "Default Process", 2);
        ((IterableAssert)Assertions.assertThat((Iterable)body.getNodeInstances()).hasSize(3)).extractingResultOf("getNodeType").contains(new Object[]{"StartNode", "RuleSetNode", "EndNode"});
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getTriggerTime").allMatch(v -> v != null);
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getLeaveTime").allMatch(v -> v != null);
        ((MapAssert)Assertions.assertThat((Map)body.getVariables()).hasSize(1)).containsKey((Object)"person");
        ((ObjectAssert)Assertions.assertThat(body.getVariables().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
    }

    @Test
    public void testBasicUserTaskProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        TestEventPublisher publisher = new TestEventPublisher();
        app.unitOfWorkManager().eventManager().setService("http://myhost");
        app.unitOfWorkManager().eventManager().addPublisher((EventPublisher)publisher);
        UnitOfWork uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        uow.end();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List<DataEvent<?>> events = publisher.extract();
        ((ListAssert)Assertions.assertThat(events).isNotNull()).hasSize(2);
        ProcessInstanceEventBody body = this.assertProcessInstanceEvent(events.get(0), "UserTasksProcess", "UserTasksProcess", 1);
        ((IterableAssert)Assertions.assertThat((Iterable)body.getNodeInstances()).hasSize(2)).extractingResultOf("getNodeType").contains(new Object[]{"StartNode", "HumanTaskNode"});
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getTriggerTime").allMatch(v -> v != null);
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getLeaveTime").containsNull();
        this.assertUserTaskInstanceEvent(events.get(1), "First Task", null, "1", "Ready", "UserTasksProcess");
        List workItems = processInstance.workItems(new Policy[]{SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"))});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)((WorkItem)workItems.get(0)).getName());
        uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"))});
        uow.end();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        events = publisher.extract();
        ((ListAssert)Assertions.assertThat(events).isNotNull()).hasSize(3);
        body = this.assertProcessInstanceEvent(events.get(0), "UserTasksProcess", "UserTasksProcess", 1);
        ((IterableAssert)Assertions.assertThat((Iterable)body.getNodeInstances()).hasSize(2)).extractingResultOf("getNodeType").contains(new Object[]{"HumanTaskNode", "HumanTaskNode"});
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getTriggerTime").allMatch(v -> v != null);
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getLeaveTime").containsNull();
        this.assertUserTaskInstanceEvent(events.get(1), "Second Task", null, "1", "Ready", "UserTasksProcess");
        this.assertUserTaskInstanceEvent(events.get(2), "First Task", null, "1", "Completed", "UserTasksProcess");
        workItems = processInstance.workItems(new Policy[]{SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"))});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)((WorkItem)workItems.get(0)).getName());
        uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"))});
        uow.end();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        events = publisher.extract();
        ((ListAssert)Assertions.assertThat(events).isNotNull()).hasSize(2);
        body = this.assertProcessInstanceEvent(events.get(0), "UserTasksProcess", "UserTasksProcess", 2);
        ((IterableAssert)Assertions.assertThat((Iterable)body.getNodeInstances()).hasSize(2)).extractingResultOf("getNodeType").contains(new Object[]{"HumanTaskNode", "EndNode"});
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getTriggerTime").allMatch(v -> v != null);
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getLeaveTime").allMatch(v -> v != null);
        this.assertUserTaskInstanceEvent(events.get(1), "Second Task", null, "1", "Completed", "UserTasksProcess");
    }

    @Test
    public void testBasicUserTaskProcessWithSecurityRoles() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcessWithSecurityRoles.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        TestEventPublisher publisher = new TestEventPublisher();
        app.unitOfWorkManager().eventManager().setService("http://myhost");
        app.unitOfWorkManager().eventManager().addPublisher((EventPublisher)publisher);
        UnitOfWork uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        uow.end();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List<DataEvent<?>> events = publisher.extract();
        ((ListAssert)Assertions.assertThat(events).isNotNull()).hasSize(2);
        ProcessInstanceEventBody body = this.assertProcessInstanceEvent(events.get(0), "UserTasksProcess", "UserTasksProcess", 1);
        ((ListAssert)Assertions.assertThat((List)body.getRoles()).hasSize(2)).contains((Object[])new String[]{"employees", "managers"});
        ((IterableAssert)Assertions.assertThat((Iterable)body.getNodeInstances()).hasSize(2)).extractingResultOf("getNodeType").contains(new Object[]{"StartNode", "HumanTaskNode"});
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getTriggerTime").allMatch(v -> v != null);
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getLeaveTime").containsNull();
        this.assertUserTaskInstanceEvent(events.get(1), "First Task", null, "1", "Ready", "UserTasksProcess");
    }

    @Test
    public void testBasicCallActivityTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("subprocess/CallActivity.bpmn2", "subprocess/CallActivitySubProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ParentProcess");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("x", "a");
        parameters.put("y", "b");
        m.fromMap(parameters);
        TestEventPublisher publisher = new TestEventPublisher();
        app.unitOfWorkManager().eventManager().setService("http://myhost");
        app.unitOfWorkManager().eventManager().addPublisher((EventPublisher)publisher);
        UnitOfWork uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        uow.end();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKeys((Object[])new String[]{"x", "y"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("y")).isNotNull()).isEqualTo((Object)"new value");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("x")).isNotNull()).isEqualTo((Object)"a");
        List<DataEvent<?>> events = publisher.extract();
        ((ListAssert)Assertions.assertThat(events).isNotNull()).hasSize(2);
        DataEvent<?> parent = null;
        DataEvent<?> child = null;
        for (DataEvent<?> e : events) {
            ProcessInstanceDataEvent processDataEvent = (ProcessInstanceDataEvent)e;
            if (processDataEvent.getKogitoProcessId().equals("ParentProcess")) {
                parent = e;
                Assertions.assertThat((String)processDataEvent.getKogitoProcessinstanceId()).isNotNull();
                Assertions.assertThat((String)processDataEvent.getKogitoParentProcessinstanceId()).isNull();
                Assertions.assertThat((String)processDataEvent.getKogitoRootProcessinstanceId()).isNull();
                Assertions.assertThat((String)processDataEvent.getKogitoRootProcessId()).isNull();
                Assertions.assertThat((String)processDataEvent.getKogitoProcessId()).isEqualTo("ParentProcess");
                Assertions.assertThat((String)processDataEvent.getKogitoProcessinstanceState()).isEqualTo("2");
                continue;
            }
            child = e;
            Assertions.assertThat((String)processDataEvent.getKogitoProcessinstanceId()).isNotNull();
            Assertions.assertThat((String)processDataEvent.getKogitoParentProcessinstanceId()).isNotNull();
            Assertions.assertThat((String)processDataEvent.getKogitoRootProcessinstanceId()).isNotNull();
            Assertions.assertThat((String)processDataEvent.getKogitoProcessId()).isEqualTo("SubProcess");
            Assertions.assertThat((String)processDataEvent.getKogitoRootProcessId()).isEqualTo("ParentProcess");
            Assertions.assertThat((String)processDataEvent.getKogitoProcessinstanceState()).isEqualTo("2");
        }
        ProcessInstanceEventBody parentBody = this.assertProcessInstanceEvent(parent, "ParentProcess", "Parent Process", 2);
        ((IterableAssert)Assertions.assertThat((Iterable)parentBody.getNodeInstances()).hasSize(3)).extractingResultOf("getNodeType").contains(new Object[]{"StartNode", "SubProcessNode", "EndNode"});
        Assertions.assertThat((Iterable)parentBody.getNodeInstances()).extractingResultOf("getTriggerTime").allMatch(v -> v != null);
        Assertions.assertThat((Iterable)parentBody.getNodeInstances()).extractingResultOf("getLeaveTime").allMatch(v -> v != null);
        ProcessInstanceEventBody childBody = this.assertProcessInstanceEventWithParentId(child, "SubProcess", "Sub Process", 2);
        ((IterableAssert)Assertions.assertThat((Iterable)childBody.getNodeInstances()).hasSize(3)).extractingResultOf("getNodeType").contains(new Object[]{"StartNode", "ActionNode", "EndNode"});
        Assertions.assertThat((Iterable)childBody.getNodeInstances()).extractingResultOf("getTriggerTime").allMatch(v -> v != null);
        Assertions.assertThat((Iterable)childBody.getNodeInstances()).extractingResultOf("getLeaveTime").allMatch(v -> v != null);
    }

    @Test
    public void testBusinessRuleProcessStartToEndAbortOfUoW() throws Exception {
        Application app = this.generateCode(Collections.singletonList("ruletask/BusinessRuleTask.bpmn2"), Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        TestEventPublisher publisher = new TestEventPublisher();
        app.unitOfWorkManager().eventManager().setService("http://myhost");
        app.unitOfWorkManager().eventManager().addPublisher((EventPublisher)publisher);
        UnitOfWork uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        Process p = app.processes().processById("BusinessRuleTask");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
        uow.abort();
        List<DataEvent<?>> events = publisher.extract();
        ((ListAssert)Assertions.assertThat(events).isNotNull()).hasSize(0);
    }

    @Test
    public void testExclusiveGatewayStartToEnd() throws Exception {
        Application app = this.generateCodeProcessesOnly("gateway/ExclusiveSplit.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        TestEventPublisher publisher = new TestEventPublisher();
        app.unitOfWorkManager().eventManager().setService("http://myhost");
        app.unitOfWorkManager().eventManager().addPublisher((EventPublisher)publisher);
        UnitOfWork uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        Process p = app.processes().processById("ExclusiveSplit");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "None");
        Model m = (Model)p.createModel();
        m.fromMap(params);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKeys((Object[])new String[]{"x", "y"});
        uow.end();
        List<DataEvent<?>> events = publisher.extract();
        ((ListAssert)Assertions.assertThat(events).isNotNull()).hasSize(1);
        DataEvent<?> event = events.get(0);
        Assertions.assertThat(event).isInstanceOf(ProcessInstanceDataEvent.class);
        ProcessInstanceDataEvent processDataEvent = (ProcessInstanceDataEvent)event;
        Assertions.assertThat((String)processDataEvent.getKogitoProcessinstanceId()).isNotNull();
        Assertions.assertThat((String)processDataEvent.getKogitoParentProcessinstanceId()).isNull();
        Assertions.assertThat((String)processDataEvent.getKogitoRootProcessinstanceId()).isNull();
        Assertions.assertThat((String)processDataEvent.getKogitoProcessId()).isEqualTo("ExclusiveSplit");
        Assertions.assertThat((String)processDataEvent.getKogitoProcessinstanceState()).isEqualTo("2");
        ProcessInstanceEventBody body = this.assertProcessInstanceEvent(events.get(0), "ExclusiveSplit", "Test", 2);
        ((IterableAssert)Assertions.assertThat((Iterable)body.getNodeInstances()).hasSize(6)).extractingResultOf("getNodeType").contains(new Object[]{"StartNode", "ActionNode", "Split", "Join", "EndNode", "WorkItemNode"});
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getTriggerTime").allMatch(v -> v != null);
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getLeaveTime").allMatch(v -> v != null);
    }

    @Test
    public void testServiceTaskProcessWithError() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/ServiceProcessDifferentOperations.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        TestEventPublisher publisher = new TestEventPublisher();
        app.unitOfWorkManager().eventManager().setService("http://myhost");
        app.unitOfWorkManager().eventManager().addPublisher((EventPublisher)publisher);
        UnitOfWork uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        Process p = app.processes().processById("ServiceProcessDifferentOperations");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        uow.end();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(5);
        List<DataEvent<?>> events = publisher.extract();
        ((ListAssert)Assertions.assertThat(events).isNotNull()).hasSize(1);
        ProcessInstanceEventBody body = this.assertProcessInstanceEvent(events.get(0), "ServiceProcessDifferentOperations", "Service Process", 5);
        ((IterableAssert)Assertions.assertThat((Iterable)body.getNodeInstances()).hasSize(2)).extractingResultOf("getNodeType").contains(new Object[]{"StartNode", "WorkItemNode"});
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getTriggerTime").allMatch(v -> v != null);
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getLeaveTime").containsNull();
        Assertions.assertThat((Object)body.getError()).isNotNull();
        Assertions.assertThat((String)body.getError().getErrorMessage()).contains(new CharSequence[]{"java.lang.NullPointerException - null"});
        Assertions.assertThat((String)body.getError().getNodeDefinitionId()).isEqualTo("_38E04E27-3CCA-47F9-927B-E37DC4B8CE25");
        parameters.put("s", "john");
        m.fromMap(parameters);
        uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        processInstance.updateVariables((Object)m);
        uow.end();
        events = publisher.extract();
        ((ListAssert)Assertions.assertThat(events).isNotNull()).hasSize(1);
        body = this.assertProcessInstanceEvent(events.get(0), "ServiceProcessDifferentOperations", "Service Process", 5);
        Assertions.assertThat((Object)body.getError()).isNotNull();
        Assertions.assertThat((String)body.getError().getErrorMessage()).contains(new CharSequence[]{"java.lang.NullPointerException - null"});
        Assertions.assertThat((String)body.getError().getNodeDefinitionId()).isEqualTo("_38E04E27-3CCA-47F9-927B-E37DC4B8CE25");
        uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        if (processInstance.error().isPresent()) {
            ((ProcessError)processInstance.error().get()).retrigger();
        }
        uow.end();
        events = publisher.extract();
        ((ListAssert)Assertions.assertThat(events).isNotNull()).hasSize(1);
        body = this.assertProcessInstanceEvent(events.get(0), "ServiceProcessDifferentOperations", "Service Process", 2);
        Assertions.assertThat((Object)body.getError()).isNull();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"s"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("s")).isNotNull()).isEqualTo((Object)"Goodbye Hello john!!");
    }

    @Test
    public void testBusinessRuleProcessStartToEndWithVariableTracked() throws Exception {
        Application app = this.generateCode(Collections.singletonList("ruletask/BusinessRuleTaskVariableTags.bpmn2"), Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        TestEventPublisher publisher = new TestEventPublisher();
        app.unitOfWorkManager().eventManager().setService("http://myhost");
        app.unitOfWorkManager().eventManager().addPublisher((EventPublisher)publisher);
        UnitOfWork uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        Process p = app.processes().processById("BusinessRuleTask");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
        uow.end();
        List<DataEvent<?>> events = publisher.extract();
        ((ListAssert)Assertions.assertThat(events).isNotNull()).hasSize(3);
        DataEvent<?> event = events.get(0);
        Assertions.assertThat(event).isInstanceOf(ProcessInstanceDataEvent.class);
        ProcessInstanceDataEvent processDataEvent = (ProcessInstanceDataEvent)event;
        Assertions.assertThat((String)processDataEvent.getKogitoProcessinstanceId()).isNotNull();
        Assertions.assertThat((String)processDataEvent.getKogitoParentProcessinstanceId()).isNull();
        Assertions.assertThat((String)processDataEvent.getKogitoRootProcessinstanceId()).isNull();
        Assertions.assertThat((String)processDataEvent.getKogitoProcessId()).isEqualTo("BusinessRuleTask");
        Assertions.assertThat((String)processDataEvent.getKogitoProcessinstanceState()).isEqualTo("2");
        Assertions.assertThat((String)processDataEvent.getSource()).isEqualTo("http://myhost/BusinessRuleTask");
        ProcessInstanceEventBody body = this.assertProcessInstanceEvent(events.get(0), "BusinessRuleTask", "Default Process", 2);
        ((IterableAssert)Assertions.assertThat((Iterable)body.getNodeInstances()).hasSize(3)).extractingResultOf("getNodeType").contains(new Object[]{"StartNode", "RuleSetNode", "EndNode"});
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getTriggerTime").allMatch(v -> v != null);
        Assertions.assertThat((Iterable)body.getNodeInstances()).extractingResultOf("getLeaveTime").allMatch(v -> v != null);
        ((MapAssert)Assertions.assertThat((Map)body.getVariables()).hasSize(1)).containsKey((Object)"person");
        ((ObjectAssert)Assertions.assertThat(body.getVariables().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
        event = events.get(1);
        Assertions.assertThat(event).isInstanceOf(VariableInstanceDataEvent.class);
        VariableInstanceDataEvent variableDataEvent = (VariableInstanceDataEvent)event;
        Assertions.assertThat((String)variableDataEvent.getKogitoProcessinstanceId()).isNotNull();
        Assertions.assertThat((String)variableDataEvent.getKogitoRootProcessId()).isNull();
        Assertions.assertThat((String)variableDataEvent.getKogitoRootProcessinstanceId()).isNull();
        Assertions.assertThat((String)variableDataEvent.getKogitoProcessId()).isEqualTo("BusinessRuleTask");
        VariableInstanceEventBody variableEventBody = (VariableInstanceEventBody)variableDataEvent.getData();
        Assertions.assertThat((Object)variableEventBody).isNotNull();
        Assertions.assertThat((Date)variableEventBody.getChangeDate()).isNotNull();
        Assertions.assertThat((String)variableEventBody.getProcessInstanceId()).isEqualTo(variableDataEvent.getKogitoProcessinstanceId());
        Assertions.assertThat((String)variableEventBody.getProcessId()).isEqualTo("BusinessRuleTask");
        Assertions.assertThat((String)variableEventBody.getRootProcessId()).isNull();
        Assertions.assertThat((String)variableEventBody.getRootProcessInstanceId()).isNull();
        Assertions.assertThat((String)variableEventBody.getVariableName()).isEqualTo("person");
        Assertions.assertThat((Object)variableEventBody.getVariableValue()).isNotNull();
        Assertions.assertThat((Object)variableEventBody.getVariablePreviousValue()).isNull();
        Assertions.assertThat((String)variableEventBody.getChangedByNodeId()).isNull();
        Assertions.assertThat((String)variableEventBody.getChangedByNodeName()).isNull();
        Assertions.assertThat((String)variableEventBody.getChangedByNodeType()).isNull();
        Assertions.assertThat((String)variableEventBody.getChangedByUser()).isNull();
        event = events.get(2);
        Assertions.assertThat(event).isInstanceOf(VariableInstanceDataEvent.class);
        variableDataEvent = (VariableInstanceDataEvent)event;
        Assertions.assertThat((String)variableDataEvent.getKogitoProcessinstanceId()).isNotNull();
        Assertions.assertThat((String)variableDataEvent.getKogitoRootProcessId()).isNull();
        Assertions.assertThat((String)variableDataEvent.getKogitoRootProcessinstanceId()).isNull();
        Assertions.assertThat((String)variableDataEvent.getKogitoProcessId()).isEqualTo("BusinessRuleTask");
        variableEventBody = (VariableInstanceEventBody)variableDataEvent.getData();
        Assertions.assertThat((Object)variableEventBody).isNotNull();
        Assertions.assertThat((Date)variableEventBody.getChangeDate()).isNotNull();
        Assertions.assertThat((String)variableEventBody.getProcessInstanceId()).isEqualTo(variableDataEvent.getKogitoProcessinstanceId());
        Assertions.assertThat((String)variableEventBody.getProcessId()).isEqualTo("BusinessRuleTask");
        Assertions.assertThat((String)variableEventBody.getRootProcessId()).isNull();
        Assertions.assertThat((String)variableEventBody.getRootProcessInstanceId()).isNull();
        Assertions.assertThat((String)variableEventBody.getVariableName()).isEqualTo("person");
        Assertions.assertThat((Object)variableEventBody.getVariableValue()).isNotNull();
        Assertions.assertThat((Object)variableEventBody.getVariablePreviousValue()).isNotNull();
        Assertions.assertThat((String)variableEventBody.getChangedByNodeId()).isEqualTo("BusinessRuleTask_2");
        Assertions.assertThat((String)variableEventBody.getChangedByNodeName()).isEqualTo("Business Rule Task");
        Assertions.assertThat((String)variableEventBody.getChangedByNodeType()).isEqualTo("RuleSetNode");
        Assertions.assertThat((String)variableEventBody.getChangedByUser()).isNull();
    }

    protected ProcessInstanceEventBody assertProcessInstanceEvent(DataEvent<?> event, String processId, String processName, Integer state) {
        Assertions.assertThat(event).isInstanceOf(ProcessInstanceDataEvent.class);
        ProcessInstanceEventBody body = (ProcessInstanceEventBody)((ProcessInstanceDataEvent)event).getData();
        Assertions.assertThat((Object)body).isNotNull();
        Assertions.assertThat((String)body.getId()).isNotNull();
        Assertions.assertThat((Date)body.getStartDate()).isNotNull();
        if (state == 1 || state == 5) {
            Assertions.assertThat((Date)body.getEndDate()).isNull();
        } else {
            Assertions.assertThat((Date)body.getEndDate()).isNotNull();
        }
        Assertions.assertThat((String)body.getParentInstanceId()).isNull();
        Assertions.assertThat((String)body.getRootInstanceId()).isNull();
        Assertions.assertThat((String)body.getProcessId()).isEqualTo(processId);
        Assertions.assertThat((String)body.getProcessName()).isEqualTo(processName);
        Assertions.assertThat((Integer)body.getState()).isEqualTo((Object)state);
        Assertions.assertThat((String)event.getSource()).isEqualTo("http://myhost/" + processId);
        Assertions.assertThat((String)event.getTime()).doesNotContain(new CharSequence[]{"["});
        Assertions.assertThat((String)((ProcessInstanceDataEvent)event).getKogitoAddons()).isEqualTo("test");
        return body;
    }

    protected UserTaskInstanceEventBody assertUserTaskInstanceEvent(DataEvent<?> event, String taskName, String taskDescription, String taskPriority, String taskState, String processId) {
        Assertions.assertThat(event).isInstanceOf(UserTaskInstanceDataEvent.class);
        UserTaskInstanceEventBody body = (UserTaskInstanceEventBody)((UserTaskInstanceDataEvent)event).getData();
        Assertions.assertThat((Object)body).isNotNull();
        Assertions.assertThat((String)body.getId()).isNotNull();
        Assertions.assertThat((String)body.getTaskName()).isEqualTo(taskName);
        Assertions.assertThat((String)body.getTaskDescription()).isEqualTo(taskDescription);
        Assertions.assertThat((String)body.getTaskPriority()).isEqualTo(taskPriority);
        Assertions.assertThat((Date)body.getStartDate()).isNotNull();
        Assertions.assertThat((String)body.getState()).isEqualTo(taskState);
        if (taskState.equals("Completed")) {
            Assertions.assertThat((Date)body.getCompleteDate()).isNotNull();
        } else {
            Assertions.assertThat((Date)body.getCompleteDate()).isNull();
        }
        Assertions.assertThat((String)event.getSource()).isEqualTo("http://myhost/" + processId);
        Assertions.assertThat((String)event.getTime()).doesNotContain(new CharSequence[]{"["});
        Assertions.assertThat((String)((UserTaskInstanceDataEvent)event).getKogitoAddons()).isEqualTo("test");
        return body;
    }

    protected ProcessInstanceEventBody assertProcessInstanceEventWithParentId(DataEvent<?> event, String processId, String processName, Integer state) {
        Assertions.assertThat(event).isInstanceOf(ProcessInstanceDataEvent.class);
        ProcessInstanceEventBody body = (ProcessInstanceEventBody)((ProcessInstanceDataEvent)event).getData();
        Assertions.assertThat((Object)body).isNotNull();
        Assertions.assertThat((String)body.getId()).isNotNull();
        Assertions.assertThat((Date)body.getStartDate()).isNotNull();
        if (state == 1) {
            Assertions.assertThat((Date)body.getEndDate()).isNull();
        } else {
            Assertions.assertThat((Date)body.getEndDate()).isNotNull();
        }
        Assertions.assertThat((String)body.getParentInstanceId()).isNotNull();
        Assertions.assertThat((String)body.getRootInstanceId()).isNotNull();
        Assertions.assertThat((String)body.getProcessId()).isEqualTo(processId);
        Assertions.assertThat((String)body.getProcessName()).isEqualTo(processName);
        Assertions.assertThat((Integer)body.getState()).isEqualTo((Object)state);
        return body;
    }

    private class TestEventPublisher
    implements EventPublisher {
        private List<DataEvent<?>> events = new ArrayList();

        private TestEventPublisher() {
        }

        public void publish(DataEvent<?> event) {
            this.events.add(event);
        }

        public void publish(Collection<DataEvent<?>> events) {
            this.events.addAll(events);
        }

        public List<DataEvent<?>> extract() {
            ArrayList copied = new ArrayList(this.events);
            this.events.clear();
            return copied;
        }
    }
}

