/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.decision;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.decision.DecisionCodegen;
import org.kie.kogito.grafana.JGrafana;

public class DecisionCodegenTest {
    @Test
    public void generateSingleFile() throws Exception {
        DecisionCodegen codeGenerator = DecisionCodegen.ofPath((Path)Paths.get("src/test/resources/decision", new String[0]).toAbsolutePath());
        List generatedFiles = codeGenerator.generate();
        Assertions.assertEquals((int)2, (int)generatedFiles.size());
        ClassOrInterfaceDeclaration classDeclaration = codeGenerator.moduleGenerator().classDeclaration();
        Assertions.assertNotNull((Object)classDeclaration);
    }

    @Test
    public void GivenADMNModel_WhenMonitoringIsActive_ThenGrafanaDashboardsAreGenerated() throws Exception {
        DecisionCodegen codeGenerator = DecisionCodegen.ofPath((Path)Paths.get("src/test/resources/decision", new String[0]).toAbsolutePath()).withMonitoring(true);
        List generatedFiles = codeGenerator.generate();
        List dashboards = generatedFiles.stream().filter(x -> x.getType() == GeneratedFile.Type.RESOURCE).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)dashboards.size());
        JGrafana vacationDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("Vacations.json")).findFirst().get().contents()));
        Assertions.assertEquals((int)7, (int)vacationDashboard.getDashboard().panels.size());
    }
}

