/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence.proto;

import com.github.javaparser.ast.CompilationUnit;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.data.PersonWithAddress;
import org.kie.kogito.codegen.data.PersonWithAddresses;
import org.kie.kogito.codegen.data.PersonWithList;
import org.kie.kogito.codegen.process.persistence.MarshallerGenerator;
import org.kie.kogito.codegen.process.persistence.proto.Proto;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

public class MarshallerGeneratorTest {
    private ProtoGenerator<Class<?>> generator = new ReflectionProtoGenerator();

    @Test
    public void testPersonMarshallers() throws Exception {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(Person.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        MarshallerGenerator marshallerGenerator = new MarshallerGenerator(this.getClass().getClassLoader());
        List classes = marshallerGenerator.generate(proto.toString());
        Assertions.assertThat((List)classes).isNotNull();
        Assertions.assertThat((List)classes).hasSize(1);
        Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName("PersonMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
    }

    @Test
    public void testPersonWithListMarshallers() throws Exception {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(PersonWithList.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        System.out.println(proto.getMessages());
        MarshallerGenerator marshallerGenerator = new MarshallerGenerator(this.getClass().getClassLoader());
        List classes = marshallerGenerator.generate(proto.toString());
        Assertions.assertThat((List)classes).isNotNull();
        Assertions.assertThat((List)classes).hasSize(1);
        Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName("PersonWithListMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
    }

    @Test
    public void testPersonWithAdressMarshallers() throws Exception {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(PersonWithAddress.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        MarshallerGenerator marshallerGenerator = new MarshallerGenerator(this.getClass().getClassLoader());
        List classes = marshallerGenerator.generate(proto.toString());
        Assertions.assertThat((List)classes).isNotNull();
        Assertions.assertThat((List)classes).hasSize(2);
        Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName("AddressMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
        marshallerClass = ((CompilationUnit)classes.get(1)).getClassByName("PersonWithAddressMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
    }

    @Test
    public void testPersonWithAdressesMarshallers() throws Exception {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(PersonWithAddresses.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        System.out.println(proto.getMessages());
        MarshallerGenerator marshallerGenerator = new MarshallerGenerator(this.getClass().getClassLoader());
        List classes = marshallerGenerator.generate(proto.toString());
        Assertions.assertThat((List)classes).isNotNull();
        Assertions.assertThat((List)classes).hasSize(2);
        Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName("AddressMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
        marshallerClass = ((CompilationUnit)classes.get(1)).getClassByName("PersonWithAddressesMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
    }
}

