/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.jbpm.test.util.NodeLeftCountDownProcessEventListener;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessWorkItemTransitionEvent;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.identity.StaticIdentityProvider;

public class ServerlessWorkflowTest
extends AbstractCodegenTest {
    @ParameterizedTest
    @ValueSource(strings={"serverless/single-operation.sw.json", "serverless/single-operation.sw.yml"})
    public void testSingleFunctionCallWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("function");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/single-operation-with-delay.sw.json", "serverless/single-operation-with-delay.sw.yml"})
    public void testSingleFunctionCallWithDelayWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("SmallDelay", 1);
        ((DefaultProcessEventListenerConfig)app.config().process().processEventListeners()).register((ProcessEventListener)listener);
        Process p = app.processes().processById("function");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/single-operation-many-functions.sw.json", "serverless/single-operation-many-functions.sw.yml"})
    public void testMultipleFunctionsCallWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("function");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/multiple-operations.sw.json", "serverless/multiple-operations.sw.yml"})
    public void testMultipleOperationsWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("function");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/single-service-operation.sw.json", "serverless/single-service-operation.sw.yml"})
    public void testBasicServiceWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("singleservice");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{\n  \"name\": \"john\"\n}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"workflowdata"});
        Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
        JsonNode dataOut = (JsonNode)result.toMap().get("workflowdata");
        Assertions.assertThat((String)dataOut.get("result").textValue()).isEqualTo("Hello john");
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/single-inject-state.sw.json", "serverless/single-inject-state.sw.yml"})
    public void testSingleInjectWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("singleinject");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"workflowdata"});
        Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
        JsonNode dataOut = (JsonNode)result.toMap().get("workflowdata");
        Assertions.assertThat((String)dataOut.get("name").textValue()).isEqualTo("john");
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/switch-state.sw.json", "serverless/switch-state.sw.yml"})
    public void testApproveSwitchStateWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("switchworkflow");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"workflowdata"});
        Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
        JsonNode dataOut = (JsonNode)result.toMap().get("workflowdata");
        Assertions.assertThat((String)dataOut.get("decision").textValue()).isEqualTo("Approved");
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/switch-state-deny.sw.json", "serverless/switch-state-deny.sw.yml"})
    public void testDenySwitchStateWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("switchworkflow");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"workflowdata"});
        Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
        JsonNode dataOut = (JsonNode)result.toMap().get("workflowdata");
        Assertions.assertThat((String)dataOut.get("decision").textValue()).isEqualTo("Denied");
    }

    @Test
    public void testSubFlowWorkflow() throws Exception {
        Application app = this.generateCodeProcessesOnly("serverless/single-subflow.sw.json", "serverless/called-subflow.sw.json");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("singlesubflow");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"workflowdata"});
        Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
        JsonNode dataOut = (JsonNode)result.toMap().get("workflowdata");
        Assertions.assertThat((String)dataOut.get("parentData").textValue()).isEqualTo("parentTestData");
        Assertions.assertThat((String)dataOut.get("childData").textValue()).isEqualTo("childTestData");
    }

    @Test
    public void testParallelExecWorkflow() throws Exception {
        try {
            Application app = this.generateCodeProcessesOnly("serverless/parallel-state.sw.json", "serverless/parallel-state-branch1.sw.json", "serverless/parallel-state-branch2.sw.json");
            Assertions.assertThat((Object)app).isNotNull();
            Process p = app.processes().processById("parallelworkflow");
            Model m = (Model)p.createModel();
            HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
            String jsonParamStr = "{}";
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
            parameters.put("workflowdata", jsonParamObj);
            m.fromMap(parameters);
            ProcessInstance processInstance = p.createInstance(m);
            processInstance.start();
            Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
            Model result = (Model)processInstance.variables();
            ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"workflowdata"});
            Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
            JsonNode dataOut = (JsonNode)result.toMap().get("workflowdata");
            Assertions.assertThat((String)dataOut.get("branch1data").textValue()).isEqualTo("testBranch1Data");
            Assertions.assertThat((String)dataOut.get("branch2data").textValue()).isEqualTo("testBranch2Data");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/decision-workflow.sw.json", "serverless/decision-workflow.sw.yml"})
    public void testSingleDecisionWorkflow(String processLocation) throws Exception {
        SecurityPolicy securityPolicy = SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("workflow"));
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        final ArrayList workItemTransitionEvents = new ArrayList();
        app.config().process().processEventListeners().listeners().add(new DefaultProcessEventListener(){

            public void beforeWorkItemTransition(ProcessWorkItemTransitionEvent event) {
                workItemTransitionEvents.add("BEFORE:: " + event);
            }

            public void afterWorkItemTransition(ProcessWorkItemTransitionEvent event) {
                workItemTransitionEvents.add("AFTER:: " + event);
            }
        });
        Process p = app.processes().processById("decisionworkflow");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        parameters.put("approvaldecision", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"approval", (Object)((WorkItem)workItems.get(0)).getName());
        String decisionParamStr = "{\"result\": \"approved\"}";
        JsonNode decisionParamObj = mapper.readTree(decisionParamStr);
        HashMap<String, JsonNode> completionMap = new HashMap<String, JsonNode>();
        completionMap.put("decision", decisionParamObj);
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), completionMap, new Policy[]{securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Assertions.assertThat(workItemTransitionEvents).hasSize(4);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKeys((Object[])new String[]{"workflowdata", "approvaldecision"});
        Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
        Assertions.assertThat(result.toMap().get("approvaldecision")).isInstanceOf(JsonNode.class);
        JsonNode workflowdataOut = (JsonNode)result.toMap().get("workflowdata");
        JsonNode approvalDecisionOut = (JsonNode)result.toMap().get("approvaldecision");
        Assertions.assertThat((String)workflowdataOut.get("decision").textValue()).isEqualTo("Approved");
        Assertions.assertThat((String)approvalDecisionOut.get("result").textValue()).isEqualTo("approved");
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/multi-decision-workflow.sw.json", "serverless/multi-decision-workflow.sw.yml"})
    public void testMultiDecisionWorkflow(String processLocation) throws Exception {
        SecurityPolicy securityPolicy = SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("workflow"));
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        final ArrayList workItemTransitionEvents = new ArrayList();
        app.config().process().processEventListeners().listeners().add(new DefaultProcessEventListener(){

            public void beforeWorkItemTransition(ProcessWorkItemTransitionEvent event) {
                workItemTransitionEvents.add("BEFORE:: " + event);
            }

            public void afterWorkItemTransition(ProcessWorkItemTransitionEvent event) {
                workItemTransitionEvents.add("AFTER:: " + event);
            }
        });
        Process p = app.processes().processById("multidecisionworkflow");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        parameters.put("approvaldecision", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"firstfunction", (Object)((WorkItem)workItems.get(0)).getName());
        String decisionParamStr = "{\"result\": \"approved\"}";
        JsonNode decisionParamObj = mapper.readTree(decisionParamStr);
        HashMap<String, JsonNode> decisionMap = new HashMap<String, JsonNode>();
        decisionMap.put("decision", decisionParamObj);
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), decisionMap, new Policy[]{securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"secondfunction", (Object)((WorkItem)workItems.get(0)).getName());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), decisionMap, new Policy[]{securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Assertions.assertThat(workItemTransitionEvents).hasSize(8);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(3)).containsKeys((Object[])new String[]{"workflowdata", "firstfunctiondecision", "secondfunctiondecision"});
        Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
        Assertions.assertThat(result.toMap().get("firstfunctiondecision")).isInstanceOf(JsonNode.class);
        Assertions.assertThat(result.toMap().get("secondfunctiondecision")).isInstanceOf(JsonNode.class);
        JsonNode firstDecisionOut = (JsonNode)result.toMap().get("firstfunctiondecision");
        JsonNode secondDecisionOut = (JsonNode)result.toMap().get("secondfunctiondecision");
        Assertions.assertThat((String)firstDecisionOut.get("result").textValue()).isEqualTo("approved");
        Assertions.assertThat((String)secondDecisionOut.get("result").textValue()).isEqualTo("approved");
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/rule-workflow.sw.json", "serverless/rule-workflow.sw.yml"})
    public void testRuleWorkflow(String processLocation) throws Exception {
        Application app = this.generateCode(Collections.singletonList(processLocation), Collections.singletonList("serverless/workflowrule.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ruleworkflow");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{ \"person\": { \"age\": \"21\" } }";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"workflowdata"});
        Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
        JsonNode workflowdataOut = (JsonNode)result.toMap().get("workflowdata");
        Assertions.assertThat((String)workflowdataOut.get("person").get("age").textValue()).isEqualTo("21");
        Assertions.assertThat((String)workflowdataOut.get("person").get("adult").textValue()).isEqualTo("true");
    }
}

