/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.decision;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.AddonsConfig;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.decision.DecisionCodegen;
import org.kie.kogito.grafana.JGrafana;

public class DecisionCodegenTest {
    @Test
    public void generateAllFiles() throws Exception {
        GeneratorContext context = this.stronglyTypedContext();
        DecisionCodegen codeGenerator = DecisionCodegen.ofPath((Path[])new Path[]{Paths.get("src/test/resources/decision/models/vacationDays", new String[0]).toAbsolutePath()});
        codeGenerator.setContext(context);
        List generatedFiles = codeGenerator.generate();
        Assertions.assertEquals((int)5, (int)generatedFiles.size());
        Assertions.assertIterableEquals(Arrays.asList("decision/InputSet.java", "decision/TEmployee.java", "decision/TAddress.java", "decision/TPayroll.java", "decision/VacationsResource.java"), this.fileNames(generatedFiles));
        ClassOrInterfaceDeclaration classDeclaration = codeGenerator.moduleGenerator().classDeclaration();
        Assertions.assertNotNull((Object)classDeclaration);
    }

    private GeneratorContext stronglyTypedContext() {
        Properties properties = new Properties();
        properties.put(DecisionCodegen.STRONGLY_TYPED_CONFIGURATION_KEY, Boolean.TRUE.toString());
        return GeneratorContext.ofProperties((Properties)properties);
    }

    private List<String> fileNames(List<GeneratedFile> generatedFiles) {
        return generatedFiles.stream().map(GeneratedFile::relativePath).collect(Collectors.toList());
    }

    @Test
    public void doNotGenerateTypesafeInfo() throws Exception {
        GeneratorContext context = this.stronglyTypedContext();
        DecisionCodegen codeGenerator = DecisionCodegen.ofPath((Path[])new Path[]{Paths.get("src/test/resources/decision/alltypes/", new String[0]).toAbsolutePath()});
        codeGenerator.setContext(context);
        List generatedFiles = codeGenerator.generate();
        Assertions.assertEquals((int)2, (int)generatedFiles.size());
        Assertions.assertIterableEquals(Arrays.asList("http_58_47_47www_46trisotech_46com_47definitions_47__4f5608e9_454d74_454c22_45a47e_45ab657257fc9c/InputSet.java", "http_58_47_47www_46trisotech_46com_47definitions_47__4f5608e9_454d74_454c22_45a47e_45ab657257fc9c/OneOfEachTypeResource.java"), this.fileNames(generatedFiles));
        ClassOrInterfaceDeclaration classDeclaration = codeGenerator.moduleGenerator().classDeclaration();
        Assertions.assertNotNull((Object)classDeclaration);
    }

    @Test
    public void givenADMNModelWhenMonitoringIsActiveThenGrafanaDashboardsAreGenerated() throws Exception {
        List<GeneratedFile> dashboards = this.generateTestDashboards(new AddonsConfig().withMonitoring(true));
        JGrafana vacationOperationalDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("operational-dashboard-Vacations.json")).findFirst().get().contents()));
        Assertions.assertEquals((int)6, (int)vacationOperationalDashboard.getDashboard().panels.size());
        Assertions.assertEquals((int)0, (int)vacationOperationalDashboard.getDashboard().links.size());
        JGrafana vacationDomainDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("domain-dashboard-Vacations.json")).findFirst().get().contents()));
        Assertions.assertEquals((int)1, (int)vacationDomainDashboard.getDashboard().panels.size());
        Assertions.assertEquals((int)0, (int)vacationDomainDashboard.getDashboard().links.size());
    }

    @Test
    public void givenADMNModelWhenMonitoringAndTracingAreActiveThenTheGrafanaDashboardsContainsTheAuditUILink() throws Exception {
        List<GeneratedFile> dashboards = this.generateTestDashboards(new AddonsConfig().withMonitoring(true).withTracing(true));
        JGrafana vacationOperationalDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("operational-dashboard-Vacations.json")).findFirst().get().contents()));
        Assertions.assertEquals((int)1, (int)vacationOperationalDashboard.getDashboard().links.size());
        JGrafana vacationDomainDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("domain-dashboard-Vacations.json")).findFirst().get().contents()));
        Assertions.assertEquals((int)1, (int)vacationDomainDashboard.getDashboard().links.size());
    }

    @Test
    public void resilientToDuplicateDMNIDs() throws Exception {
        DecisionCodegen codeGenerator = DecisionCodegen.ofPath((Path[])new Path[]{Paths.get("src/test/resources/decision-test20200507", new String[0]).toAbsolutePath()});
        List generatedFiles = codeGenerator.generate();
        Assertions.assertEquals((int)2, (int)generatedFiles.size());
        ClassOrInterfaceDeclaration classDeclaration = codeGenerator.moduleGenerator().classDeclaration();
        Assertions.assertNotNull((Object)classDeclaration);
    }

    @Test
    public void emptyName() throws Exception {
        DecisionCodegen codeGenerator = DecisionCodegen.ofPath((Path[])new Path[]{Paths.get("src/test/resources/decision-empty-name", new String[0]).toAbsolutePath()});
        RuntimeException re = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> codeGenerator.generate());
        Assertions.assertEquals((Object)"Model name should not be empty", (Object)re.getMessage());
    }

    private List<GeneratedFile> generateTestDashboards(AddonsConfig addonsConfig) throws IOException {
        DecisionCodegen codeGenerator = DecisionCodegen.ofPath((Path[])new Path[]{Paths.get("src/test/resources/decision/models/vacationDays", new String[0]).toAbsolutePath()}).withAddons(addonsConfig);
        List generatedFiles = codeGenerator.generate();
        List<GeneratedFile> dashboards = generatedFiles.stream().filter(x -> x.getType() == GeneratedFile.Type.RESOURCE).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)dashboards.size());
        return dashboards;
    }
}

