/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence.proto;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.data.PersonVarInfo;
import org.kie.kogito.codegen.data.PersonWithAddress;
import org.kie.kogito.codegen.data.PersonWithAddresses;
import org.kie.kogito.codegen.data.PersonWithList;
import org.kie.kogito.codegen.process.persistence.proto.Proto;
import org.kie.kogito.codegen.process.persistence.proto.ProtoField;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoMessage;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

public class ReflectionProtoGeneratorTest {
    private ProtoGenerator<Class<?>> generator = new ReflectionProtoGenerator();

    @Test
    public void testPersonProtoFile() {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(Person.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("Person");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(3);
        ProtoField field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
    }

    @Test
    public void testPersonWithAddressProtoFile() {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(PersonWithAddress.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        ProtoMessage address = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)address).isNotNull();
        Assertions.assertThat((String)address.getName()).isEqualTo("Address");
        Assertions.assertThat((String)address.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)address.getFields()).hasSize(4);
        ProtoField field = (ProtoField)address.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("city");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("country");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("street");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("zipCode");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(1);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("PersonWithAddress");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(4);
        field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("address");
        Assertions.assertThat((String)field.getType()).isEqualTo("Address");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
    }

    @Test
    public void testPersonWithListProtoFile() {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(PersonWithList.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage address = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)address).isNotNull();
        Assertions.assertThat((String)address.getName()).isEqualTo("PersonWithList");
        Assertions.assertThat((String)address.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)address.getFields()).hasSize(7);
        ProtoField field = (ProtoField)address.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("booleanList");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
        field = (ProtoField)address.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("integerList");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
        field = (ProtoField)address.getFields().get(4);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("longList");
        Assertions.assertThat((String)field.getType()).isEqualTo("int64");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
        field = (ProtoField)address.getFields().get(5);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(6);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("stringList");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
    }

    @Test
    public void testPersonWithAddressesProtoFile() {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(PersonWithAddresses.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        ProtoMessage address = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)address).isNotNull();
        Assertions.assertThat((String)address.getName()).isEqualTo("Address");
        Assertions.assertThat((String)address.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)address.getFields()).hasSize(4);
        ProtoField field = (ProtoField)address.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("city");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("country");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("street");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("zipCode");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(1);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("PersonWithAddresses");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(4);
        field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("addresses");
        Assertions.assertThat((String)field.getType()).isEqualTo("Address");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
    }

    @Test
    public void testPersonAsModelProtoFile() {
        Proto proto = this.generator.generate("@Indexed", "@Field(store = Store.YES)", "org.kie.kogito.test.persons", Person.class, new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("Person");
        Assertions.assertThat((String)person.getComment()).isEqualTo("@Indexed");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((List)person.getFields()).hasSize(3);
        ProtoField field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(store = Store.YES)");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(store = Store.YES)");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(store = Store.YES)");
    }

    @Test
    public void testPersonWithVariableInfoAsModelProtoFile() {
        Proto proto = this.generator.generate("@Indexed", "@Field(store = Store.YES)", "org.kie.kogito.test.persons", PersonVarInfo.class, new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("PersonVarInfo");
        Assertions.assertThat((String)person.getComment()).isEqualTo("@Indexed");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((List)person.getFields()).hasSize(3);
        ProtoField field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(store = Store.YES)");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(store = Store.YES)");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(store = Store.YES)\n @VariableInfo(tags=\"test\")");
    }
}

