/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.rules;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.compiler.compiler.DecisionTableFactory;
import org.drools.compiler.compiler.DecisionTableProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.api.io.ResourceType;
import org.kie.kogito.codegen.AddonsConfig;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.rules.IncrementalRuleCodegen;
import org.kie.kogito.codegen.rules.MissingDecisionTableDependencyError;
import org.kie.kogito.codegen.rules.RuleCodegenError;

public class IncrementalRuleCodegenTest {
    @BeforeEach
    public void setup() {
        DecisionTableFactory.setDecisionTableProvider((DecisionTableProvider)((DecisionTableProvider)ServiceRegistry.getInstance().get(DecisionTableProvider.class)));
    }

    @Test
    public void generateSingleFile() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofFiles(Collections.singleton(new File("src/test/resources/org/kie/kogito/codegen/rules/pkg1/file1.drl")), (ResourceType)ResourceType.DRL);
        incrementalRuleCodegen.setPackageName("com.acme");
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        IncrementalRuleCodegenTest.assertRules(3, 1, generatedFiles.size());
    }

    @Test
    public void generateSinglePackage() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofFiles(Arrays.asList(new File("src/test/resources/org/kie/kogito/codegen/rules/pkg1").listFiles()), (ResourceType)ResourceType.DRL);
        incrementalRuleCodegen.setPackageName("com.acme");
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        IncrementalRuleCodegenTest.assertRules(5, 1, generatedFiles.size());
    }

    @Test
    public void generateSinglePackageSingleUnit() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofFiles(Arrays.asList(new File("src/test/resources/org/kie/kogito/codegen/rules/multiunit").listFiles()), (ResourceType)ResourceType.DRL);
        incrementalRuleCodegen.setPackageName("org.kie.kogito.codegen.rules.multiunit");
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        IncrementalRuleCodegenTest.assertRules(2, 1, 1, generatedFiles.size());
    }

    @Test
    public void generateDirectoryRecursively() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofPath((Path)Paths.get("src/test/resources/org/kie/kogito/codegen/rules", new String[0]), (ResourceType)ResourceType.DRL);
        incrementalRuleCodegen.setPackageName("com.acme");
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        IncrementalRuleCodegenTest.assertRules(14, 5, 3, generatedFiles.size());
    }

    @Test
    public void generateSingleDtable() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofFiles(Collections.singleton(new File("src/test/resources/org/drools/simple/candrink/CanDrink.xls")));
        incrementalRuleCodegen.setPackageName("com.acme");
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        int externalizedLambda = 5;
        IncrementalRuleCodegenTest.assertRules(2, 1, generatedFiles.size() - externalizedLambda);
    }

    @Test
    public void generateSingleUnit() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofPath((Path)Paths.get("src/test/resources/org/kie/kogito/codegen/rules/myunit", new String[0]), (ResourceType)ResourceType.DRL);
        incrementalRuleCodegen.setPackageName("com.acme");
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        IncrementalRuleCodegenTest.assertRules(1, 1, 1, generatedFiles.size());
    }

    @Test
    public void generateCepRule() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofFiles(Collections.singleton(new File("src/test/resources/org/drools/simple/cep/cep.drl")));
        incrementalRuleCodegen.setPackageName("com.acme");
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        int externalizedLambda = 2;
        IncrementalRuleCodegenTest.assertRules(2, 1, generatedFiles.size() - externalizedLambda);
    }

    @Test
    public void raiseErrorOnSyntaxError() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofFiles(Collections.singleton(new File("src/test/resources/org/drools/simple/broken.drl")));
        incrementalRuleCodegen.setPackageName("com.acme");
        Assertions.assertThrows(RuleCodegenError.class, () -> ((IncrementalRuleCodegen)incrementalRuleCodegen.withHotReloadMode()).generate());
    }

    @Test
    public void raiseErrorOnBadOOPath() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofFiles(Collections.singleton(new File("src/test/resources/org/kie/kogito/codegen/brokenrules/brokenunit/ABrokenUnit.drl")));
        incrementalRuleCodegen.setPackageName("com.acme");
        Assertions.assertThrows(RuleCodegenError.class, () -> ((IncrementalRuleCodegen)incrementalRuleCodegen.withHotReloadMode()).generate());
    }

    @Test
    public void throwWhenDtableDependencyMissing() {
        DecisionTableFactory.setDecisionTableProvider(null);
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofFiles(Collections.singleton(new File("src/test/resources/org/drools/simple/candrink/CanDrink.xls")));
        incrementalRuleCodegen.setPackageName("com.acme");
        Assertions.assertThrows(MissingDecisionTableDependencyError.class, () -> ((IncrementalRuleCodegen)incrementalRuleCodegen.withHotReloadMode()).generate());
    }

    @Test
    public void generateGrafanaDashboards() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofFiles(Collections.singleton(new File("src/test/resources/org/kie/kogito/codegen/unit/RuleUnitQuery.drl"))).withAddons(new AddonsConfig().withMonitoring(true));
        incrementalRuleCodegen.setPackageName("com.acme");
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        Assertions.assertEquals((long)2L, (long)generatedFiles.stream().filter(x -> x.getType() == GeneratedFile.Type.RESOURCE).count());
    }

    private static void assertRules(int expectedRules, int expectedPackages, int expectedUnits, int actualGeneratedFiles) {
        Assertions.assertEquals((int)(expectedRules + expectedPackages * 2 + expectedUnits * 3), (int)(actualGeneratedFiles - 2));
    }

    private static void assertRules(int expectedRules, int expectedPackages, int actualGeneratedFiles) {
        Assertions.assertEquals((int)(expectedRules + expectedPackages * 2), (int)(actualGeneratedFiles - 2));
    }
}

