/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.data.Address;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.data.PersonWithAddress;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.identity.StaticIdentityProvider;

public class CallActivityTaskTest
extends AbstractCodegenTest {
    private Policy<?> securityPolicy = SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"));

    @Test
    public void testBasicCallActivityTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("subprocess/CallActivity.bpmn2", "subprocess/CallActivitySubProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ParentProcess");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("x", "a");
        parameters.put("y", "b");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKeys((Object[])new String[]{"x", "y"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("y")).isNotNull()).isEqualTo((Object)"new value");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("x")).isNotNull()).isEqualTo((Object)"a");
    }

    @Test
    public void testBasicCallActivityTaskWithTypeInfo() throws Exception {
        Application app = this.generateCodeProcessesOnly("subprocess/CallActivityWithTypeInfo.bpmn2", "subprocess/CallActivitySubProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ParentProcess");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("x", "a");
        parameters.put("y", "b");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKeys((Object[])new String[]{"x", "y"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("y")).isNotNull()).isEqualTo((Object)"new value");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("x")).isNotNull()).isEqualTo((Object)"a");
    }

    @Test
    public void testCallActivityTaskMultiInstance() throws Exception {
        Application app = this.generateCodeProcessesOnly("subprocess/CallActivityMI.bpmn2", "subprocess/CallActivitySubProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ParentProcess");
        ArrayList<String> list = new ArrayList<String>();
        list.add("first");
        list.add("second");
        ArrayList listOut = new ArrayList();
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        parameters.put("list", list);
        parameters.put("listOut", listOut);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(4)).containsKeys((Object[])new String[]{"x", "y", "list", "listOut"});
        ((ListAssert)Assertions.assertThat((List)((List)result.toMap().get("listOut"))).isNotNull()).hasSize(2);
    }

    @Test
    public void testCallActivityTaskWithExpressionsForIO() throws Exception {
        Application app = this.generateCodeProcessesOnly("subprocess/CallActivityWithIOexpression.bpmn2", "subprocess/CallActivitySubProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ParentProcess");
        Model m = (Model)p.createModel();
        HashMap<String, Person> parameters = new HashMap<String, Person>();
        parameters.put("person", new Person("john", 0));
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"person"});
        Person person = (Person)result.toMap().get("person");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new value", (Object)person.getName());
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"MyTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testCallActivityTaskWithExpressionsForIONested() throws Exception {
        Application app = this.generateCodeProcessesOnly("subprocess/CallActivityWithIOexpressionNested.bpmn2", "subprocess/CallActivitySubProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ParentProcess");
        Model m = (Model)p.createModel();
        HashMap<String, PersonWithAddress> parameters = new HashMap<String, PersonWithAddress>();
        PersonWithAddress pa = new PersonWithAddress("john", 0);
        pa.setAddress(new Address("test", null, null, null));
        parameters.put("person", pa);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"person"});
        PersonWithAddress person = (PersonWithAddress)result.toMap().get("person");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", (Object)person.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)person.getAddress().getStreet());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new value", (Object)person.getAddress().getCity());
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"MyTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testBasicCallActivityTaskWithSingleVarExpression() throws Exception {
        Application app = this.generateCodeProcessesOnly("subprocess/CallActivityVarIOExpression.bpmn2", "subprocess/CallActivitySubProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ParentProcess");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("x", "a");
        parameters.put("y", "b");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKeys((Object[])new String[]{"x", "y"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("y")).isNotNull()).isEqualTo((Object)"new value");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("x")).isNotNull()).isEqualTo((Object)"a");
    }
}

