/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerFactory;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.rule.builder.dialect.java.JavaDialectConfiguration;
import org.kie.kogito.Application;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.context.KogitoBuildContext;
import org.kie.kogito.codegen.context.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.context.SpringBootKogitoBuildContext;
import org.kie.kogito.codegen.decision.DecisionCodegen;
import org.kie.kogito.codegen.prediction.PredictionCodegen;
import org.kie.kogito.codegen.process.ProcessCodegen;
import org.kie.kogito.codegen.rules.IncrementalRuleCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCodegenTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCodegenTest.class);
    private TestClassLoader classloader;
    private static final JavaCompiler JAVA_COMPILER = JavaCompilerFactory.INSTANCE.loadCompiler(JavaDialectConfiguration.CompilerType.NATIVE, "11");
    private static final String TEST_JAVA = "src/test/java/";
    private static final String TEST_RESOURCES = "src/test/resources";
    private static final Map<TYPE, Function<List<String>, Generator>> generatorTypeMap = new HashMap<TYPE, Function<List<String>, Generator>>();
    private boolean withSpringContext;

    public void withSpringContext(boolean withSpringContext) {
        this.withSpringContext = withSpringContext;
    }

    protected Application generateCodeProcessesOnly(String ... processes) throws Exception {
        HashMap<TYPE, List<String>> resourcesTypeMap = new HashMap<TYPE, List<String>>();
        resourcesTypeMap.put(TYPE.PROCESS, Arrays.asList(processes));
        return this.generateCode(resourcesTypeMap, false);
    }

    protected Application generateCodeRulesOnly(String ... rules) throws Exception {
        HashMap<TYPE, List<String>> resourcesTypeMap = new HashMap<TYPE, List<String>>();
        resourcesTypeMap.put(TYPE.RULES, Arrays.asList(rules));
        return this.generateCode(resourcesTypeMap, true);
    }

    protected Application generateRulesFromJava(String ... javaSourceCode) throws Exception {
        HashMap<TYPE, List<String>> resourcesTypeMap = new HashMap<TYPE, List<String>>();
        resourcesTypeMap.put(TYPE.JAVA, Arrays.asList(javaSourceCode));
        return this.generateCode(resourcesTypeMap, true);
    }

    protected Application generateCode(Map<TYPE, List<String>> resourcesTypeMap, boolean hasRuleUnit) throws Exception {
        GeneratorContext context = GeneratorContext.ofResourcePath((File[])new File[]{new File(TEST_RESOURCES)});
        context.withBuildContext(Optional.ofNullable(this.withSpringContext).filter(Boolean.TRUE::equals).map(t -> new SpringBootKogitoBuildContext(className -> true)).orElse((KogitoBuildContext)new QuarkusKogitoBuildContext(className -> true)));
        ApplicationGenerator appGen = new ApplicationGenerator(this.getClass().getPackage().getName(), new File("target/codegen-tests")).withGeneratorContext(context).withRuleUnits(hasRuleUnit).withDependencyInjection(null);
        HashSet<TYPE> generatedTypes = new HashSet<TYPE>();
        for (TYPE type : TYPE.values()) {
            if (!resourcesTypeMap.containsKey((Object)type) || resourcesTypeMap.get((Object)type).isEmpty()) continue;
            appGen.withGenerator(generatorTypeMap.get((Object)type).apply(resourcesTypeMap.get((Object)type)));
            generatedTypes.add(type);
        }
        if (generatedTypes.contains((Object)TYPE.DECISION) && !generatedTypes.contains((Object)TYPE.PREDICTION)) {
            appGen.withGenerator(generatorTypeMap.get((Object)TYPE.PREDICTION).apply(Collections.EMPTY_LIST));
        }
        Collection generatedFiles = appGen.generate();
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        MemoryFileSystem trgMfs = new MemoryFileSystem();
        ArrayList<String> sources = new ArrayList<String>();
        for (Object entry : generatedFiles) {
            String fileName = entry.relativePath();
            if (!fileName.endsWith(".java")) continue;
            sources.add(fileName);
            srcMfs.write(fileName, entry.contents());
            this.log(new String(entry.contents()));
        }
        if (logger.isDebugEnabled()) {
            Path temp = Files.createTempDirectory("KOGITO_TESTS", new FileAttribute[0]);
            logger.debug("Dumping generated files in " + temp);
            for (GeneratedFile entry : generatedFiles) {
                Path fpath = temp.resolve(entry.relativePath());
                fpath.getParent().toFile().mkdirs();
                Files.write(fpath, entry.contents(), new OpenOption[0]);
            }
        }
        CompilationResult result = JAVA_COMPILER.compile(sources.toArray(new String[sources.size()]), (ResourceReader)srcMfs, (ResourceStore)trgMfs, this.getClass().getClassLoader());
        Assertions.assertThat((Object)result).isNotNull();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.getErrors()).describedAs(String.join((CharSequence)"\n\n", Arrays.toString(result.getErrors())), new Object[0])).hasSize(0);
        this.classloader = new TestClassLoader(this.getClass().getClassLoader(), trgMfs.getMap());
        Class<?> app = Class.forName(this.getClass().getPackage().getName() + ".Application", true, this.classloader);
        Application application = (Application)app.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return application;
    }

    protected ClassLoader testClassLoader() {
        return this.classloader;
    }

    protected void log(String content) {
        logger.debug(content);
    }

    static {
        generatorTypeMap.put(TYPE.PROCESS, strings -> ProcessCodegen.ofFiles((Collection)strings.stream().map(resource -> new File(TEST_RESOURCES, (String)resource)).collect(Collectors.toList())));
        generatorTypeMap.put(TYPE.RULES, strings -> IncrementalRuleCodegen.ofFiles((Collection)strings.stream().map(resource -> new File(TEST_RESOURCES, (String)resource)).collect(Collectors.toList())));
        generatorTypeMap.put(TYPE.DECISION, strings -> DecisionCodegen.ofFiles((Path)Paths.get(TEST_RESOURCES, new String[0]).toAbsolutePath(), strings.stream().map(resource -> new File(TEST_RESOURCES, (String)resource)).collect(Collectors.toList())));
        generatorTypeMap.put(TYPE.JAVA, strings -> IncrementalRuleCodegen.ofJavaFiles((Collection)strings.stream().map(resource -> new File(TEST_JAVA, (String)resource)).collect(Collectors.toList())));
        generatorTypeMap.put(TYPE.PREDICTION, strings -> PredictionCodegen.ofFiles((Path)Paths.get(TEST_RESOURCES, new String[0]).toAbsolutePath(), strings.stream().map(resource -> new File(TEST_RESOURCES, (String)resource)).collect(Collectors.toList())));
    }

    private static class TestClassLoader
    extends URLClassLoader {
        private final Map<String, byte[]> extraClassDefs = new HashMap<String, byte[]>();

        public TestClassLoader(ClassLoader parent, Map<String, byte[]> extraClassDefs) {
            super(new URL[0], parent);
            for (Map.Entry<String, byte[]> entry : extraClassDefs.entrySet()) {
                this.extraClassDefs.put(entry.getKey().replaceAll("/", ".").replaceFirst("\\.class", ""), entry.getValue());
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] classBytes = this.extraClassDefs.remove(name);
            if (classBytes != null) {
                return this.defineClass(name, classBytes, 0, classBytes.length);
            }
            return super.findClass(name);
        }
    }

    protected static enum TYPE {
        PROCESS,
        RULES,
        DECISION,
        JAVA,
        PREDICTION;

    }
}

