/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.decision;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.AddonsConfig;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.decision.DecisionCodegen;

public class DecisionModelResourcesProviderCodegenTest {
    @Test
    public void generateDecisionModelResourcesProvider() throws Exception {
        GeneratorContext context = GeneratorContext.ofProperties((Properties)new Properties());
        DecisionCodegen codeGenerator = DecisionCodegen.ofPath((Path[])new Path[]{Paths.get("src/test/resources/decision/models/vacationDays", new String[0]).toAbsolutePath()}).withAddons(new AddonsConfig().withTracing(true));
        codeGenerator.setContext(context);
        List generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(2);
        Optional<GeneratedFile> generatedRESTFile = generatedFiles.stream().filter(gf -> gf.getType() == GeneratedFile.Type.REST).findFirst();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedRESTFile.isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"decision/VacationsResource.java", (Object)generatedRESTFile.get().relativePath());
        Optional<GeneratedFile> generatedCLASSFile = generatedFiles.stream().filter(gf -> gf.getType() == GeneratedFile.Type.CLASS).findFirst();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedCLASSFile.isPresent());
        GeneratedFile classFile = generatedCLASSFile.get();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"org/kie/kogito/app/DecisionModelResourcesProvider.java", (Object)classFile.relativePath());
        CompilationUnit compilationUnit = StaticJavaParser.parse((InputStream)new ByteArrayInputStream(classFile.contents()));
        ClassOrInterfaceDeclaration classDeclaration = (ClassOrInterfaceDeclaration)compilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new NoSuchElementException("Compilation unit doesn't contain a class or interface declaration!"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)classDeclaration);
        MethodDeclaration methodDeclaration = (MethodDeclaration)classDeclaration.findFirst(MethodDeclaration.class, d -> d.getName().getIdentifier().equals("getResources")).orElseThrow(() -> new NoSuchElementException("Class declaration doesn't contain a method named \"getResources\"!"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)methodDeclaration);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)methodDeclaration.getBody().isPresent());
        BlockStmt body = (BlockStmt)methodDeclaration.getBody().get();
        org.junit.jupiter.api.Assertions.assertTrue((body.getStatements().size() > 2 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Statement)body.getStatements().get(1)).isExpressionStmt());
        ExpressionStmt expression = (ExpressionStmt)body.getStatements().get(1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression.getExpression() instanceof MethodCallExpr));
        MethodCallExpr call = (MethodCallExpr)expression.getExpression();
        org.junit.jupiter.api.Assertions.assertEquals((Object)call.getName().getIdentifier(), (Object)"add");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)call.getScope().isPresent());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Expression)call.getScope().get()).isNameExpr());
        NameExpr nameExpr = ((Expression)call.getScope().get()).asNameExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)nameExpr.getName().getIdentifier(), (Object)"resourcePaths");
    }
}

