/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.prediction;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.prediction.PredictionRuleMapperGenerator;

class PredictionRuleMapperGeneratorTest {
    PredictionRuleMapperGeneratorTest() {
    }

    @Test
    void getPredictionRuleMapperSourceWithoutPackage() {
        String fullRuleName = "FULL_RULE_NAME";
        String retrieved = PredictionRuleMapperGenerator.getPredictionRuleMapperSource((String)"FULL_RULE_NAME");
        Assertions.assertNotNull((Object)retrieved);
        String expected = String.format("public final static String ruleName = \"%s\";", "FULL_RULE_NAME");
        Assertions.assertTrue((boolean)retrieved.contains(expected));
    }

    @Test
    void getPredictionRuleMapperSourceWithPackage() {
        String packageName = "PACKAGE";
        String ruleName = "RULE_NAME";
        String fullRuleName = "PACKAGE.RULE_NAME";
        String retrieved = PredictionRuleMapperGenerator.getPredictionRuleMapperSource((String)"PACKAGE.RULE_NAME");
        Assertions.assertNotNull((Object)retrieved);
        String expected = String.format("package %s;", "PACKAGE");
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        expected = String.format("public final static String ruleName = \"%s\";", "PACKAGE.RULE_NAME");
        Assertions.assertTrue((boolean)retrieved.contains(expected));
    }
}

