/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.events;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.process.ProcessGenerationUtils;
import org.kie.kogito.codegen.process.events.CloudEventsResourceGenerator;

class CloudEventsResourceGeneratorTest {
    CloudEventsResourceGeneratorTest() {
    }

    @Test
    void verifyBasicGenerationCase() {
        String sourceCode = new CloudEventsResourceGenerator(Collections.emptyList()).generate();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)sourceCode);
        CompilationUnit clazz = StaticJavaParser.parse((String)sourceCode);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)clazz);
        Assertions.assertThat((List)clazz.getChildNodes()).isNotEmpty();
        Assertions.assertThat((List)clazz.getImports()).contains((Object[])new ImportDeclaration[]{new ImportDeclaration("org.kie.kogito.events.knative.ce.http.RestEasyHttpRequestConverter", false, false)});
    }

    @Test
    void generatedFilePath() throws URISyntaxException {
        String filePath = new CloudEventsResourceGenerator(Collections.emptyList()).generatedFilePath();
        Assertions.assertThat((String)new URI(filePath).toString()).endsWith((CharSequence)".java");
    }

    @Test
    void verifyProcessWithIntermediateEvent() {
        CloudEventsResourceGenerator generator = new CloudEventsResourceGenerator(ProcessGenerationUtils.execModelFromProcessFile("/messageevent/IntermediateCatchEventMessage.bpmn2"));
        String source = generator.generate();
        Assertions.assertThat((String)source).isNotNull();
        Assertions.assertThat((List)generator.getTriggers()).hasSize(1);
        ClassOrInterfaceDeclaration clazz = (ClassOrInterfaceDeclaration)StaticJavaParser.parse((String)source).getClassByName("CloudEventListenerResource").orElseThrow(() -> new IllegalArgumentException("Class does not exists"));
        Assertions.assertThat((long)clazz.getFields().stream().filter(f -> f.getAnnotationByName("Channel").isPresent()).count()).isEqualTo(1L);
        Assertions.assertThat((long)clazz.getFields().stream().filter(f -> f.getAnnotationByName("Inject").isPresent()).count()).isEqualTo(1L);
    }
}

