/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence.proto;

import com.github.javaparser.ast.CompilationUnit;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.data.Answer;
import org.kie.kogito.codegen.data.AnswerWitAnnotations;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.data.PersonWithAddress;
import org.kie.kogito.codegen.data.PersonWithAddresses;
import org.kie.kogito.codegen.data.PersonWithList;
import org.kie.kogito.codegen.data.Question;
import org.kie.kogito.codegen.data.QuestionWithAnnotatedEnum;
import org.kie.kogito.codegen.process.persistence.MarshallerGenerator;
import org.kie.kogito.codegen.process.persistence.proto.Proto;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

class MarshallerGeneratorTest {
    private ProtoGenerator<Class<?>> generator = new ReflectionProtoGenerator();

    MarshallerGeneratorTest() {
    }

    @Test
    void testPersonMarshallers() throws Exception {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(Person.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        MarshallerGenerator marshallerGenerator = new MarshallerGenerator(this.getClass().getClassLoader());
        List classes = marshallerGenerator.generate(proto.toString());
        Assertions.assertThat((List)classes).isNotNull();
        Assertions.assertThat((List)classes).hasSize(1);
        Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName("PersonMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
    }

    @Test
    void testPersonWithListMarshallers() throws Exception {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(PersonWithList.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        System.out.println(proto.getMessages());
        MarshallerGenerator marshallerGenerator = new MarshallerGenerator(this.getClass().getClassLoader());
        List classes = marshallerGenerator.generate(proto.toString());
        Assertions.assertThat((List)classes).isNotNull();
        Assertions.assertThat((List)classes).hasSize(1);
        Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName("PersonWithListMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
    }

    @Test
    void testPersonWithAddressMarshallers() throws Exception {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(PersonWithAddress.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        MarshallerGenerator marshallerGenerator = new MarshallerGenerator(this.getClass().getClassLoader());
        List classes = marshallerGenerator.generate(proto.toString());
        Assertions.assertThat((List)classes).isNotNull();
        Assertions.assertThat((List)classes).hasSize(2);
        Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName("AddressMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
        marshallerClass = ((CompilationUnit)classes.get(1)).getClassByName("PersonWithAddressMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
    }

    @Test
    void testPersonWithAddressesMarshallers() throws Exception {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(PersonWithAddresses.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        System.out.println(proto.getMessages());
        MarshallerGenerator marshallerGenerator = new MarshallerGenerator(this.getClass().getClassLoader());
        List classes = marshallerGenerator.generate(proto.toString());
        Assertions.assertThat((List)classes).isNotNull();
        Assertions.assertThat((List)classes).hasSize(2);
        Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName("AddressMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
        marshallerClass = ((CompilationUnit)classes.get(1)).getClassByName("PersonWithAddressesMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
    }

    @Test
    void testEnumInPojosMarshallers() throws Exception {
        Stream.of(Question.class, QuestionWithAnnotatedEnum.class).forEach(c -> {
            Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(c), new String[0]);
            Assertions.assertThat((Object)proto).isNotNull();
            Assertions.assertThat((List)proto.getMessages()).hasSize(1);
            MarshallerGenerator marshallerGenerator = new MarshallerGenerator(this.getClass().getClassLoader());
            List classes = null;
            try {
                classes = marshallerGenerator.generate(proto.toString());
            }
            catch (IOException e) {
                Assertions.fail((String)("Error generating marshaller for " + c.getName()), (Throwable)e);
            }
            Assertions.assertThat((List)classes).isNotNull();
            Assertions.assertThat((List)classes).hasSize(2);
            Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName(c.getSimpleName() + "MessageMarshaller");
            Assertions.assertThat((Optional)marshallerClass).isPresent();
            String answerType = null;
            try {
                answerType = c.getDeclaredField("answer").getType().getSimpleName();
            }
            catch (NoSuchFieldException e) {
                Assertions.fail((String)("Unable to get answer field type for " + c.getName()), (Throwable)e);
            }
            marshallerClass = ((CompilationUnit)classes.get(1)).getClassByName(answerType + "EnumMarshaller");
            Assertions.assertThat((Optional)marshallerClass).isPresent();
        });
    }

    @Test
    void testEnumMarshallers() {
        Stream.of(Answer.class, AnswerWitAnnotations.class).forEach(e -> {
            Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(e), new String[0]);
            Assertions.assertThat((Object)proto).isNotNull();
            Assertions.assertThat((List)proto.getEnums()).hasSize(1);
            MarshallerGenerator marshallerGenerator = new MarshallerGenerator(this.getClass().getClassLoader());
            List classes = null;
            try {
                classes = marshallerGenerator.generate(proto.toString());
            }
            catch (IOException ex) {
                Assertions.fail((String)("Error generating marshaller for " + e.getName()), (Object[])new Object[]{e});
            }
            Assertions.assertThat((List)classes).isNotNull();
            Assertions.assertThat((List)classes).hasSize(1);
            Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName(e.getSimpleName() + "EnumMarshaller");
            Assertions.assertThat((Optional)marshallerClass).isPresent();
        });
    }
}

