/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.process.GroupedNamedDataType;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.uow.UnitOfWork;

public class SignalEventTest
extends AbstractCodegenTest {
    @Test
    public void testIntermediateSignalEventWithData() throws Exception {
        HashMap<AbstractCodegenTest.TYPE, List<String>> resourcesTypeMap = new HashMap<AbstractCodegenTest.TYPE, List<String>>();
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.PROCESS, Collections.singletonList("signalevent/IntermediateCatchEventSignal.bpmn2"));
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.RULES, Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Application app = this.generateCode(resourcesTypeMap, false);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("IntermediateCatchEvent");
        Model m = (Model)p.createModel();
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Set eventDescriptions = processInstance.events();
        ((IterableAssert)Assertions.assertThat((Iterable)eventDescriptions).hasSize(1)).extracting("event").contains(new Object[]{"workItemCompleted"});
        Assertions.assertThat((Iterable)eventDescriptions).extracting("eventType").contains(new Object[]{"workItem"});
        Assertions.assertThat((Iterable)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.id()});
        List workItems = processInstance.workItems(new Policy[0]);
        Assertions.assertThat((List)workItems).hasSize(1);
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[0]);
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        eventDescriptions = processInstance.events();
        ((IterableAssert)Assertions.assertThat((Iterable)eventDescriptions).hasSize(1)).extracting("event").contains(new Object[]{"MyMessage"});
        Assertions.assertThat((Iterable)eventDescriptions).extracting("eventType").contains(new Object[]{"signal"});
        Assertions.assertThat((Iterable)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.id()});
        processInstance.send(Sig.of((String)"MyMessage", (Object)"test"));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKey((Object)"x");
        Assertions.assertThat(result.toMap().get("x")).isEqualTo((Object)"test");
        Assertions.assertThat((Integer)p.instances().size()).isZero();
    }

    @Test
    public void testBoundarySignalEventWithData() throws Exception {
        HashMap<AbstractCodegenTest.TYPE, List<String>> resourcesTypeMap = new HashMap<AbstractCodegenTest.TYPE, List<String>>();
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.PROCESS, Collections.singletonList("signalevent/BoundarySignalEventOnTask.bpmn2"));
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.RULES, Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Application app = this.generateCode(resourcesTypeMap, false);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("BoundarySignalOnTask");
        Model m = (Model)p.createModel();
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Set eventDescriptions = processInstance.events();
        ((IterableAssert)Assertions.assertThat((Iterable)eventDescriptions).hasSize(2)).extracting("event").contains(new Object[]{"MySignal", "workItemCompleted"});
        Assertions.assertThat((Iterable)eventDescriptions).extracting("eventType").contains(new Object[]{"signal", "workItem"});
        Assertions.assertThat((Iterable)eventDescriptions).extracting("dataType").hasAtLeastOneElementOfType(GroupedNamedDataType.class);
        Assertions.assertThat((Iterable)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.id()});
        processInstance.send(Sig.of((String)"MySignal", (Object)"test"));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"x");
        Assertions.assertThat(result.toMap().get("x")).isEqualTo((Object)"test");
        Assertions.assertThat((Integer)p.instances().size()).isZero();
    }

    @Test
    public void testBoundaryInterruptingSignalEventWithData() throws Exception {
        HashMap<AbstractCodegenTest.TYPE, List<String>> resourcesTypeMap = new HashMap<AbstractCodegenTest.TYPE, List<String>>();
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.PROCESS, Collections.singletonList("signalevent/BoundaryInterruptingSignalEventOnTask.bpmn2"));
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.RULES, Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Application app = this.generateCode(resourcesTypeMap, false);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("BoundarySignalOnTask");
        Model m = (Model)p.createModel();
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.send(Sig.of((String)"MySignal", (Object)"test"));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"x");
        Assertions.assertThat(result.toMap().get("x")).isEqualTo((Object)"test");
        Assertions.assertThat((Integer)p.instances().size()).isZero();
    }

    @Test
    public void testIntermediateSignalEventWithDataControlledByUnitOfWork() throws Exception {
        HashMap<AbstractCodegenTest.TYPE, List<String>> resourcesTypeMap = new HashMap<AbstractCodegenTest.TYPE, List<String>>();
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.PROCESS, Collections.singletonList("signalevent/IntermediateCatchEventSignal.bpmn2"));
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.RULES, Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Application app = this.generateCode(resourcesTypeMap, false);
        Assertions.assertThat((Object)app).isNotNull();
        UnitOfWork uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        Process p = app.processes().processById("IntermediateCatchEvent");
        Model m = (Model)p.createModel();
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((Integer)p.instances().size()).isZero();
        uow.end();
        Assertions.assertThat((Integer)p.instances().size()).isEqualTo(1);
        uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        List workItems = processInstance.workItems(new Policy[0]);
        Assertions.assertThat((List)workItems).hasSize(1);
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[0]);
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        uow.end();
        uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        processInstance.send(Sig.of((String)"MyMessage", (Object)"test"));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKey((Object)"x");
        Assertions.assertThat(result.toMap().get("x")).isEqualTo((Object)"test");
        Assertions.assertThat((Integer)p.instances().size()).isEqualTo(1);
        uow.end();
        Assertions.assertThat((Integer)p.instances().size()).isZero();
    }
}

