/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.AddonsConfig;
import org.kie.kogito.codegen.ApplicationContainerGenerator;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.di.CDIDependencyInjectionAnnotator;
import org.kie.kogito.codegen.di.DependencyInjectionAnnotator;
import org.kie.kogito.codegen.metadata.MetaDataWriter;
import org.kie.kogito.codegen.metadata.PrometheusLabeler;

public class ApplicationGeneratorTest {
    private static final String PACKAGE_NAME = "org.drools.test";
    private static final String EXPECTED_APPLICATION_NAME = "org.drools.test.Application";

    @Test
    public void targetCanonicalName() {
        ApplicationGenerator appGenerator = new ApplicationGenerator(PACKAGE_NAME, new File(""));
        Assertions.assertThat((String)appGenerator.targetCanonicalName()).isNotNull();
        Assertions.assertThat((String)appGenerator.targetCanonicalName()).isEqualTo(EXPECTED_APPLICATION_NAME);
    }

    @Test
    public void packageNameNull() {
        Assertions.assertThatThrownBy(() -> new ApplicationGenerator(null, new File(""))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void packageNameInvalid() {
        Assertions.assertThatThrownBy(() -> new ApplicationGenerator("i.am.an-invalid.package-name.sorry", new File(""))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void generatedFilePath() {
        ApplicationGenerator appGenerator = new ApplicationGenerator(PACKAGE_NAME, new File(""));
        String path = appGenerator.generateApplicationDescriptor().relativePath();
        Assertions.assertThat((String)path).isNotNull();
        Assertions.assertThat((String)path).isEqualTo(EXPECTED_APPLICATION_NAME.replace(".", "/") + ".java");
    }

    @Test
    public void compilationUnit() {
        ApplicationContainerGenerator appGenerator = new ApplicationContainerGenerator(PACKAGE_NAME);
        this.assertCompilationUnit(appGenerator.getCompilationUnitOrThrow(), false);
    }

    @Test
    public void compilationUnitWithCDI() {
        ApplicationContainerGenerator appGenerator = new ApplicationContainerGenerator(PACKAGE_NAME);
        appGenerator.withDependencyInjection((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator());
        this.assertCompilationUnit(appGenerator.getCompilationUnitOrThrow(), true);
    }

    @Test
    public void generateWithMonitoring() throws IOException {
        Path targetDirectory = Paths.get("target", new String[0]);
        ApplicationGenerator appGenerator = new ApplicationGenerator(PACKAGE_NAME, targetDirectory.toFile()).withAddons(new AddonsConfig().withMonitoring(true));
        appGenerator.generate();
        this.assertImageMetadata(targetDirectory, new PrometheusLabeler().generateLabels());
    }

    @Test
    public void writeLabelsImageMetadata() throws IOException {
        Path targetDirectory = Paths.get("target", new String[0]);
        ApplicationGenerator appGenerator = new ApplicationGenerator(PACKAGE_NAME, targetDirectory.toFile());
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("testKey1", "testValue1");
        labels.put("testKey2", "testValue2");
        labels.put("testKey3", "testValue3");
        MetaDataWriter.writeLabelsImageMetadata((File)targetDirectory.toFile(), labels);
        this.assertImageMetadata(targetDirectory, labels);
    }

    private void assertImageMetadata(Path directory, Map<String, String> expectedLabels) throws IOException {
        try (Stream<Path> stream = Files.walk(directory, 1, new FileVisitOption[0]);){
            Optional<Path> generatedFile = stream.filter(file -> file.getFileName().toString().equals("image_metadata.json")).findFirst();
            Assertions.assertThat(generatedFile).isPresent();
            ObjectMapper mapper = new ObjectMapper();
            Map elementsFromFile = (Map)mapper.readValue(generatedFile.get().toFile(), (TypeReference)new TypeReference<Map<String, List>>(){});
            Assertions.assertThat((Map)elementsFromFile).hasSize(1);
            List listWithLabelsMap = (List)elementsFromFile.entrySet().iterator().next().getValue();
            Assertions.assertThat((List)listWithLabelsMap).isNotNull();
            Assertions.assertThat((List)listWithLabelsMap).hasSize(1);
            Assertions.assertThat((Map)((Map)listWithLabelsMap.get(0))).containsAllEntriesOf(expectedLabels);
        }
    }

    private void assertCompilationUnit(CompilationUnit compilationUnit, boolean checkCDI) {
        Assertions.assertThat((Object)compilationUnit).isNotNull();
        Assertions.assertThat((Optional)compilationUnit.getPackageDeclaration()).isPresent();
        Assertions.assertThat((String)((PackageDeclaration)compilationUnit.getPackageDeclaration().get()).getName().toString()).isEqualTo(PACKAGE_NAME);
        Assertions.assertThat((List)compilationUnit.getTypes()).isNotNull();
        Assertions.assertThat((List)compilationUnit.getTypes()).hasSize(1);
        TypeDeclaration mainAppClass = (TypeDeclaration)compilationUnit.getTypes().get(0);
        Assertions.assertThat((Object)mainAppClass).isNotNull();
        Assertions.assertThat((String)mainAppClass.getName().toString()).isEqualTo("Application");
        if (checkCDI) {
            Assertions.assertThat((List)mainAppClass.getAnnotations()).isNotEmpty();
            Assertions.assertThat((Optional)mainAppClass.getAnnotationByName("Singleton")).isPresent();
        } else {
            Assertions.assertThat((Optional)mainAppClass.getAnnotationByName("Singleton")).isNotPresent();
        }
        Assertions.assertThat((List)mainAppClass.getMembers()).isNotNull();
    }

    private void assertGeneratedFiles(Collection<GeneratedFile> generatedFiles, byte[] expectedApplicationContent, int expectedFilesCount) {
        Assertions.assertThat(generatedFiles).isNotNull();
        Assertions.assertThat(generatedFiles).hasSize(expectedFilesCount);
        for (GeneratedFile generatedFile : generatedFiles) {
            Assertions.assertThat((Object)generatedFile).isNotNull();
            Assertions.assertThat((Comparable)generatedFile.getType()).isIn(new Object[]{GeneratedFile.Type.APPLICATION, GeneratedFile.Type.APPLICATION_CONFIG, GeneratedFile.Type.APPLICATION_SECTION, GeneratedFile.Type.RULE, GeneratedFile.Type.CLASS});
            if (generatedFile.getType() != GeneratedFile.Type.APPLICATION || generatedFile.relativePath() != EXPECTED_APPLICATION_NAME.replace(".", "/") + ".java") continue;
            Assertions.assertThat((byte[])generatedFile.contents()).isEqualTo((Object)expectedApplicationContent);
        }
    }
}

