/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.victools.jsonschema.generator.SchemaVersion;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.UserTask;
import org.kie.kogito.UserTaskParam;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.JsonSchemaGenerator;

public class JsonSchemaGeneratorTest {
    @Test
    public void testSimpleSchemaGenerator() throws IOException {
        Collection files = new JsonSchemaGenerator.SimpleBuilder(Thread.currentThread().getContextClassLoader()).addSchemaName(PersonInputParams.class.getName(), "org.jbpm.test", "test").addSchemaName(PersonOutputParams.class.getName(), "org.jbpm.test", "test").build().generate();
        Assertions.assertEquals((int)1, (int)files.size());
        GeneratedFile file = (GeneratedFile)files.iterator().next();
        Assertions.assertEquals((Object)"org#jbpm#test_test.json", (Object)file.relativePath());
        this.assertSchema(file, SchemaVersion.DRAFT_7);
        Collection filesFromClasses = new JsonSchemaGenerator.ClassBuilder(Stream.of(PersonInputParams.class, PersonOutputParams.class, IgnoredClass.class)).build().generate();
        Assertions.assertEquals((int)1, (int)filesFromClasses.size());
        GeneratedFile fileFromClasses = (GeneratedFile)filesFromClasses.iterator().next();
        Assertions.assertEquals((Object)fileFromClasses.relativePath(), (Object)file.relativePath(), (String)"must have the same path of a class-based generator");
        Assertions.assertArrayEquals((byte[])fileFromClasses.contents(), (byte[])file.contents(), (String)"must have the same contents of a class-based generator");
    }

    @Test
    public void testJsonSchemaGenerator() throws IOException {
        Collection files = new JsonSchemaGenerator.ClassBuilder(Stream.of(PersonInputParams.class, PersonOutputParams.class, IgnoredClass.class)).build().generate();
        Assertions.assertEquals((int)1, (int)files.size());
        GeneratedFile file = (GeneratedFile)files.iterator().next();
        Assertions.assertEquals((Object)"org#jbpm#test_test.json", (Object)file.relativePath());
        this.assertSchema(file, SchemaVersion.DRAFT_7);
    }

    @Test
    public void testJsonSchemaGeneratorNonExistingDraft() throws IOException {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            JsonSchemaGenerator.ClassBuilder builder = new JsonSchemaGenerator.ClassBuilder(Stream.of(PersonInputParams.class, PersonOutputParams.class, IgnoredClass.class)).withSchemaNameFunction(c -> "pepe").withSchemaVersion("NON_EXISTING_DRAFT");
            builder.build().generate();
        });
    }

    @Test
    public void testJsonSchemaGeneratorDraft2019() throws IOException {
        Collection files = new JsonSchemaGenerator.ClassBuilder(Stream.of(PersonInputParams.class, PersonOutputParams.class, IgnoredClass.class)).withSchemaVersion("DRAFT_2019_09").build().generate();
        Assertions.assertEquals((int)1, (int)files.size());
        GeneratedFile file = (GeneratedFile)files.iterator().next();
        Assertions.assertEquals((Object)"org#jbpm#test_test.json", (Object)file.relativePath());
        this.assertSchema(file, SchemaVersion.DRAFT_2019_09);
    }

    @Test
    public void testJsonSchemaGeneratorInputOutput() throws IOException {
        Collection files = new JsonSchemaGenerator.ClassBuilder(Stream.of(PersonInputOutputParams.class)).build().generate();
        Assertions.assertEquals((int)1, (int)files.size());
        GeneratedFile file = (GeneratedFile)files.iterator().next();
        Assertions.assertEquals((Object)"InputOutput_test.json", (Object)file.relativePath());
        this.assertSchema(file, SchemaVersion.DRAFT_7);
    }

    private void assertSchema(GeneratedFile file, SchemaVersion schemaVersion) throws IOException {
        ObjectReader reader = new ObjectMapper().reader();
        JsonNode node = reader.readTree(file.contents());
        Assertions.assertEquals((Object)schemaVersion.getIdentifier(), (Object)node.get("$schema").asText());
        Assertions.assertEquals((Object)"object", (Object)node.get("type").asText());
        JsonNode properties = node.get("properties");
        Assertions.assertEquals((int)4, (int)properties.size());
        Assertions.assertEquals((Object)"integer", (Object)properties.get("age").get("type").asText());
        Assertions.assertEquals((Object)"string", (Object)properties.get("name").get("type").asText());
        JsonNode color = properties.get("color");
        Assertions.assertEquals((Object)"string", (Object)color.get("type").asText());
        Assertions.assertTrue((boolean)(color.get("enum") instanceof ArrayNode));
        ArrayNode colors = (ArrayNode)color.get("enum");
        EnumSet<Color> colorValues = EnumSet.noneOf(Color.class);
        colors.forEach(x -> colorValues.add(Color.valueOf(x.asText())));
        Assertions.assertArrayEquals((Object[])Color.values(), (Object[])colorValues.toArray());
        JsonNode address = properties.get("address");
        Assertions.assertEquals((Object)"object", (Object)address.get("type").asText());
        JsonNode addressProperties = address.get("properties");
        Assertions.assertEquals((Object)"string", (Object)addressProperties.get("street").get("type").asText());
        JsonNode dateNode = addressProperties.get("date");
        Assertions.assertEquals((Object)"string", (Object)dateNode.get("type").asText());
        Assertions.assertEquals((Object)"date-time", (Object)dateNode.get("format").asText());
    }

    @Test
    public void testNothingToDo() throws IOException {
        Collection files = new JsonSchemaGenerator.ClassBuilder(Stream.of(IgnoredClass.class)).build().generate();
        Assertions.assertTrue((boolean)files.isEmpty());
    }

    private static class IgnoredClass {
        @UserTaskParam(value=UserTaskParam.ParamType.OUTPUT)
        private int age;

        private IgnoredClass() {
        }
    }

    private static class Address {
        private String street;
        private Date date;

        private Address() {
        }
    }

    @UserTask(taskName="test", processName="InputOutput")
    private static class PersonInputOutputParams {
        @UserTaskParam(value=UserTaskParam.ParamType.OUTPUT)
        private int age;
        @UserTaskParam(value=UserTaskParam.ParamType.INPUT)
        private String name;
        @UserTaskParam(value=UserTaskParam.ParamType.INPUT)
        private Address address;
        @UserTaskParam(value=UserTaskParam.ParamType.INPUT)
        private Color color;

        private PersonInputOutputParams() {
        }
    }

    @UserTask(taskName="test", processName="org.jbpm.test")
    private static class PersonOutputParams {
        @UserTaskParam(value=UserTaskParam.ParamType.OUTPUT)
        private int age;
        @UserTaskParam(value=UserTaskParam.ParamType.OUTPUT)
        private String name;
        private String ignored;

        private PersonOutputParams() {
        }
    }

    @UserTask(taskName="test", processName="org.jbpm.test")
    private static class PersonInputParams {
        @UserTaskParam(value=UserTaskParam.ParamType.INPUT)
        private String name;
        @UserTaskParam(value=UserTaskParam.ParamType.INPUT)
        private Address address;
        @UserTaskParam(value=UserTaskParam.ParamType.INPUT)
        private Color color;

        private PersonInputParams() {
        }
    }

    private static enum Color {
        GREEN,
        WHITE;

    }
}

