/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen;

import java.util.NoSuchElementException;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.ResourceGeneratorFactory;
import org.kie.kogito.codegen.context.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.context.SpringBootKogitoBuildContext;
import org.kie.kogito.codegen.process.AbstractResourceGenerator;
import org.kie.kogito.codegen.process.ReactiveResourceGenerator;
import org.kie.kogito.codegen.process.ResourceGenerator;
import org.kie.kogito.codegen.process.SpringResourceGenerator;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ResourceGeneratorFactoryTest {
    public static final String MODEL_FQCN = "modelfqcn";
    public static final String PROCESS_FQCN = "processfqcn";
    public static final String APP_CANONICAL_NAME = "appCanonicalName";
    private ResourceGeneratorFactory tested;
    @Mock
    private WorkflowProcess process;

    ResourceGeneratorFactoryTest() {
    }

    @BeforeEach
    public void setUp() {
        Mockito.lenient().when((Object)this.process.getId()).thenReturn((Object)"process.id");
        Mockito.lenient().when((Object)this.process.getPackageName()).thenReturn((Object)"name.process");
        this.tested = new ResourceGeneratorFactory();
    }

    @Test
    void testCreateQuarkus(@Mock GeneratorContext generatorContext) {
        Mockito.when((Object)generatorContext.getBuildContext()).thenReturn((Object)new QuarkusKogitoBuildContext(p -> true));
        Optional context = this.tested.create(generatorContext, this.process, MODEL_FQCN, PROCESS_FQCN, APP_CANONICAL_NAME);
        Assertions.assertThat((boolean)context.isPresent()).isTrue();
        Assertions.assertThat((Object)((AbstractResourceGenerator)context.get())).isExactlyInstanceOf(ResourceGenerator.class);
    }

    @Test
    void testCreateQuarkusReactive(@Mock GeneratorContext generatorContext) {
        Mockito.when((Object)generatorContext.getApplicationProperty("kogito.rest.resource.type")).thenReturn(Optional.of("reactive"));
        Mockito.when((Object)generatorContext.getBuildContext()).thenReturn((Object)new QuarkusKogitoBuildContext(p -> true));
        Optional context = this.tested.create(generatorContext, this.process, MODEL_FQCN, PROCESS_FQCN, APP_CANONICAL_NAME);
        Assertions.assertThat((boolean)context.isPresent()).isTrue();
        Assertions.assertThat((Object)((AbstractResourceGenerator)context.get())).isExactlyInstanceOf(ReactiveResourceGenerator.class);
    }

    @Test
    void testCreateSpring(@Mock GeneratorContext generatorContext) {
        Mockito.when((Object)generatorContext.getBuildContext()).thenReturn((Object)new SpringBootKogitoBuildContext(p -> true));
        Optional context = this.tested.create(generatorContext, this.process, MODEL_FQCN, PROCESS_FQCN, APP_CANONICAL_NAME);
        Assertions.assertThat((boolean)context.isPresent()).isTrue();
        Assertions.assertThat((Object)((AbstractResourceGenerator)context.get())).isExactlyInstanceOf(SpringResourceGenerator.class);
    }

    @Test
    void testCreateSpringReactive(@Mock GeneratorContext generatorContext) {
        Mockito.when((Object)generatorContext.getApplicationProperty("kogito.rest.resource.type")).thenReturn(Optional.of("reactive"));
        Mockito.when((Object)generatorContext.getBuildContext()).thenReturn((Object)new SpringBootKogitoBuildContext(p -> true));
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchElementException.class, () -> this.tested.create(generatorContext, this.process, MODEL_FQCN, PROCESS_FQCN, APP_CANONICAL_NAME));
    }
}

