/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.decision;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.decision.DecisionCodegen;

public class DecisionValidationTest {
    private DecisionCodegen codeGenerator(String path, Consumer<Properties> codeGenContextProperties) throws Exception {
        DecisionCodegen codeGenerator = DecisionCodegen.ofPath((Path[])new Path[]{Paths.get(path, new String[0]).toAbsolutePath()});
        Properties props = new Properties();
        codeGenContextProperties.accept(props);
        codeGenerator.setContext(GeneratorContext.ofProperties((Properties)props));
        return codeGenerator;
    }

    @Test
    public void testDefault() throws Exception {
        DecisionCodegen codeGenerator = this.codeGenerator("src/test/resources/decision-validation-duplicateName", p -> {});
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> codeGenerator.generate(), (String)"Expected Validation would have failed for defaults.");
    }

    @Test
    public void testIgnore() throws Exception {
        DecisionCodegen codeGenerator = this.codeGenerator("src/test/resources/decision-validation-duplicateName", p -> p.setProperty(DecisionCodegen.VALIDATION_CONFIGURATION_KEY, "IGNORE"));
        List files = codeGenerator.generate();
        Assertions.assertThat((List)files).hasSizeGreaterThanOrEqualTo(1);
    }

    @Test
    public void testDisabled() throws Exception {
        DecisionCodegen codeGenerator = this.codeGenerator("src/test/resources/decision-validation-duplicateName", p -> p.setProperty(DecisionCodegen.VALIDATION_CONFIGURATION_KEY, "DISABLED"));
        List files = codeGenerator.generate();
        Assertions.assertThat((List)files).hasSizeGreaterThanOrEqualTo(1);
    }

    @Test
    public void testDTAnalysisDefault() throws Exception {
        DecisionCodegen codeGenerator = this.codeGenerator("src/test/resources/decision-validation-DTsemanticError", p -> {});
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> codeGenerator.generate(), (String)"Expected Validation would have failed for defaults.");
    }

    @Test
    public void testDTAnalysisIgnore() throws Exception {
        DecisionCodegen codeGenerator = this.codeGenerator("src/test/resources/decision-validation-DTsemanticError", p -> p.setProperty(DecisionCodegen.VALIDATION_CONFIGURATION_KEY, "IGNORE"));
        List files = codeGenerator.generate();
        Assertions.assertThat((List)files).hasSizeGreaterThanOrEqualTo(1);
    }

    @Test
    public void testDTAnalysisDisabled() throws Exception {
        DecisionCodegen codeGenerator = this.codeGenerator("src/test/resources/decision-validation-DTsemanticError", p -> p.setProperty(DecisionCodegen.VALIDATION_CONFIGURATION_KEY, "DISABLED"));
        List files = codeGenerator.generate();
        Assertions.assertThat((List)files).hasSizeGreaterThanOrEqualTo(1);
    }
}

