/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.metadata;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.Base64;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.assertj.core.api.Assertions;
import org.drools.core.util.IoUtils;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.metadata.PersistenceProtoFilesLabeler;

public class PersistenceProtoFilesLabelerTest {
    @Test
    void testGenerateLabels() throws URISyntaxException, IOException {
        PersistenceProtoFilesLabeler labeler = new PersistenceProtoFilesLabeler();
        File protoFile = new File(this.getClass().getResource("/kogito-types.proto").toURI());
        File kogitoApplication = new File(this.getClass().getResource("/kogito-application.proto").toURI());
        String originalContent = new String(Files.readAllBytes(protoFile.toPath()));
        Assertions.assertThat((File)protoFile).isNotNull();
        Assertions.assertThat((File)kogitoApplication).isNotNull();
        labeler.processProto(protoFile);
        labeler.processProto(kogitoApplication);
        Map labels = labeler.generateLabels();
        Assertions.assertThat((Map)labels).size().isEqualTo(1);
        Assertions.assertThat((Map)labels).containsKey((Object)labeler.generateKey(protoFile));
        byte[] bytes = Base64.getDecoder().decode((String)labels.get("org.kie/persistence/proto/kogito-types.proto"));
        byte[] decompresed = this.decompres(bytes);
        String roundTrip = new String(decompresed);
        Assertions.assertThat((String)roundTrip).isEqualTo(originalContent);
    }

    @Test
    void testGenerateLabelsIOException() throws URISyntaxException {
        PersistenceProtoFilesLabeler labeler = new PersistenceProtoFilesLabeler();
        org.junit.jupiter.api.Assertions.assertThrows(UncheckedIOException.class, () -> labeler.processProto(new File("target")));
    }

    private byte[] decompres(byte[] bytes) throws IOException {
        try (ByteArrayInputStream fileContents = new ByteArrayInputStream(bytes);){
            byte[] byArray;
            try (GZIPInputStream gzip = new GZIPInputStream(fileContents);){
                byArray = IoUtils.readBytesFromInputStream((InputStream)gzip);
            }
            return byArray;
        }
    }
}

