/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.events;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.process.ProcessGenerationUtils;
import org.kie.kogito.codegen.process.events.TopicsInformationResourceGenerator;
import org.kie.kogito.event.TopicType;

class TopicsInformationResourceGeneratorTest {
    TopicsInformationResourceGeneratorTest() {
    }

    @Test
    void verifyProcessWithMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/messageevent/IntermediateCatchEventMessage.bpmn2", 1);
        Assertions.assertThat((Object)clazz).isNotNull();
        Assertions.assertThat((Optional)clazz.getDefaultConstructor()).isPresent();
        Assertions.assertThat((List)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatements()).hasSize(2);
        Assertions.assertThat((String)((ExpressionStmt)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatement(1).toExpressionStmt().get()).getExpression().toString()).contains(new CharSequence[]{"customer"});
    }

    @Test
    void verifyProcessWithStartAndEndMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/messagestartevent/MessageStartAndEndEvent.bpmn2", 2);
        Assertions.assertThat((Object)clazz).isNotNull();
        Assertions.assertThat((Optional)clazz.getDefaultConstructor()).isPresent();
        Assertions.assertThat((List)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatements()).hasSize(3);
        ((AbstractStringAssert)Assertions.assertThat((String)((ExpressionStmt)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatement(1).toExpressionStmt().get()).getExpression().toString()).contains(new CharSequence[]{"customers"})).contains(new CharSequence[]{TopicType.CONSUMED.name()});
        ((AbstractStringAssert)Assertions.assertThat((String)((ExpressionStmt)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatement(2).toExpressionStmt().get()).getExpression().toString()).contains(new CharSequence[]{"processedcustomers"})).contains(new CharSequence[]{TopicType.PRODUCED.name()});
    }

    @Test
    void verifyProcessWithIntermediateThrowEventMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/messageevent/IntermediateThrowEventMessage.bpmn2", 1);
        Assertions.assertThat((Object)clazz).isNotNull();
        Assertions.assertThat((Optional)clazz.getDefaultConstructor()).isPresent();
        Assertions.assertThat((List)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatements()).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)((ExpressionStmt)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatement(1).toExpressionStmt().get()).getExpression().toString()).contains(new CharSequence[]{"customers"})).contains(new CharSequence[]{TopicType.PRODUCED.name()});
    }

    @Test
    void verifyProcessWithBoundaryEventMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/messageevent/BoundaryMessageEventOnTask.bpmn2", 1);
        Assertions.assertThat((Object)clazz).isNotNull();
        Assertions.assertThat((Optional)clazz.getDefaultConstructor()).isPresent();
        Assertions.assertThat((List)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatements()).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)((ExpressionStmt)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatement(1).toExpressionStmt().get()).getExpression().toString()).contains(new CharSequence[]{"customers"})).contains(new CharSequence[]{TopicType.CONSUMED.name()});
    }

    @Test
    void verifyProcessWithoutMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/usertask/approval.bpmn2", 0);
        Assertions.assertThat((Object)clazz).isNotNull();
        Assertions.assertThat((Optional)clazz.getDefaultConstructor()).isPresent();
        Assertions.assertThat((List)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatements()).hasSize(1);
    }

    private ClassOrInterfaceDeclaration generateAndParseClass(String bpmnFile, int expectedTriggers) {
        TopicsInformationResourceGenerator generator = new TopicsInformationResourceGenerator(ProcessGenerationUtils.execModelFromProcessFile(bpmnFile));
        Assertions.assertThat((List)generator.getTriggers()).hasSize(expectedTriggers);
        String source = generator.generate();
        Assertions.assertThat((String)source).isNotNull();
        ClassOrInterfaceDeclaration clazz = (ClassOrInterfaceDeclaration)StaticJavaParser.parse((String)source).getClassByName(generator.getClassName()).orElseThrow(() -> new IllegalArgumentException("Class does not exists"));
        return clazz;
    }
}

