/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence.proto;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.kie.kogito.codegen.process.persistence.proto.Proto;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

class AbstractProtoGeneratorTest {
    AbstractProtoGeneratorTest() {
    }

    @Test
    void checkGeneratedProtoBufAndListing(@TempDir Path tmpTargetDir) throws IOException {
        ReflectionProtoGenerator generator = new ReflectionProtoGenerator();
        for (int i = 0; i < 5; ++i) {
            Proto proto = new Proto("org.acme.test", new String[0]);
            generator.writeFilesToFS("protofile." + i, tmpTargetDir.toString(), proto);
        }
        generator.generateProtoListing(tmpTargetDir.toString());
        byte[] list = Files.readAllBytes(Paths.get(tmpTargetDir.toString(), "/classes/META-INF/resources/persistence/protobuf/", "list.json"));
        ObjectMapper mapper = new ObjectMapper();
        List files = (List)mapper.readValue(list, List.class);
        Assertions.assertThat((List)files).isNotEmpty();
        ((ListAssert)Assertions.assertThat((List)files).hasAtLeastOneElementOfType(String.class)).contains((Object[])new String[]{"protofile.0.proto"}).hasSize(5);
    }
}

