/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.rules.config;

import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.rules.config.NamedRuleUnitConfig;
import org.kie.kogito.conf.ClockType;
import org.kie.kogito.conf.EventProcessingType;
import org.kie.kogito.rules.RuleUnitConfig;

public class NamedRuleUnitConfigTest {
    @Test
    public void singleUnit() {
        Properties properties = new Properties();
        properties.put("kogito.rules.\"my.rule.Unit\".event-processing-type", EventProcessingType.CLOUD.name());
        properties.put("kogito.rules.\"my.rule.Unit\".clock-type", ClockType.REALTIME.name());
        properties.put("kogito.rules.\"my.rule.Unit\".sessions-pool", "10");
        GeneratorContext context = GeneratorContext.ofProperties((Properties)properties);
        List namedRuleUnitConfigs = NamedRuleUnitConfig.fromContext((GeneratorContext)context);
        Assertions.assertThat((List)namedRuleUnitConfigs).hasSize(1);
        NamedRuleUnitConfig namedRuleUnitConfig = (NamedRuleUnitConfig)namedRuleUnitConfigs.get(0);
        Assertions.assertThat((String)namedRuleUnitConfig.getCanonicalName()).isEqualTo("my.rule.Unit");
        Assertions.assertThat((Comparable)namedRuleUnitConfig.getConfig().getDefaultedEventProcessingType()).isEqualTo((Object)EventProcessingType.CLOUD);
        Assertions.assertThat((Comparable)namedRuleUnitConfig.getConfig().getDefaultedClockType()).isEqualTo((Object)ClockType.REALTIME);
        Assertions.assertThat((int)namedRuleUnitConfig.getConfig().getSessionPool().getAsInt()).isEqualTo(10);
    }

    @Test
    public void multiUnit() {
        Properties properties = new Properties();
        properties.put("kogito.rules.some.other.config", "ignore me");
        properties.put("kogito.rules.\"my.rule.Unit\".event-processing-type", EventProcessingType.CLOUD.name());
        properties.put("kogito.rules.\"my.rule.Unit\".clock-type", ClockType.PSEUDO.name());
        properties.put("kogito.rules.\"my.rule.Unit\".sessions-pool", "10");
        properties.put("kogito.rules.\"my.rule.Unit2\".event-processing-type", EventProcessingType.STREAM.name());
        GeneratorContext context = GeneratorContext.ofProperties((Properties)properties);
        List namedRuleUnitConfigs = NamedRuleUnitConfig.fromContext((GeneratorContext)context);
        Assertions.assertThat((List)namedRuleUnitConfigs).hasSize(2);
        Map<String, RuleUnitConfig> map = namedRuleUnitConfigs.stream().collect(Collectors.toMap(NamedRuleUnitConfig::getCanonicalName, NamedRuleUnitConfig::getConfig));
        RuleUnitConfig myRuleUnitConfig = map.get("my.rule.Unit");
        Assertions.assertThat((Object)myRuleUnitConfig).isNotNull();
        Assertions.assertThat((Comparable)myRuleUnitConfig.getDefaultedEventProcessingType()).isEqualTo((Object)EventProcessingType.CLOUD);
        Assertions.assertThat((Comparable)myRuleUnitConfig.getDefaultedClockType()).isEqualTo((Object)ClockType.PSEUDO);
        Assertions.assertThat((int)myRuleUnitConfig.getSessionPool().getAsInt()).isEqualTo(10);
        RuleUnitConfig myRuleUnit2Config = map.get("my.rule.Unit2");
        Assertions.assertThat((Object)myRuleUnit2Config).isNotNull();
        Assertions.assertThat((Comparable)myRuleUnit2Config.getDefaultedEventProcessingType()).isEqualTo((Object)EventProcessingType.STREAM);
        Assertions.assertThat((Comparable)myRuleUnit2Config.getDefaultedClockType()).isEqualTo((Object)ClockType.REALTIME);
        Assertions.assertThat((OptionalInt)myRuleUnit2Config.getSessionPool()).isEmpty();
    }

    @Test
    public void unbalancedParentheses() {
        Properties properties = new Properties();
        properties.put("kogito.rules.some.other.config", "ignore me");
        properties.put("kogito.rules.\"my.rule.Unit", EventProcessingType.CLOUD.name());
        GeneratorContext context = GeneratorContext.ofProperties((Properties)properties);
        List namedRuleUnitConfigs = NamedRuleUnitConfig.fromContext((GeneratorContext)context);
        Assertions.assertThat((List)namedRuleUnitConfigs).isEmpty();
    }
}

