/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;

public class EmbeddedSubProcessTest
extends AbstractCodegenTest {
    @Test
    public void testEmbeddedSubProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("subprocess/EmbeddedSubProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("SubProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testEmbeddedSubProcessWithUserTaskAndVariableScopes() throws Exception {
        Application app = this.generateCodeProcessesOnly("subprocess/EmbeddedSubProcessWithUserTask.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("embeddedWithUserTask");
        Person person = new Person("john", 25);
        Model m = (Model)p.createModel();
        HashMap<String, Person> parameters = new HashMap<String, Person>();
        parameters.put("person", person);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List tasks = processInstance.workItems(new Policy[0]);
        Assertions.assertThat((List)tasks).hasSize(1);
        WorkItem wi = processInstance.workItem(((WorkItem)tasks.get(0)).getId(), new Policy[0]);
        Assertions.assertThat((Object)wi).isNotNull();
        Assertions.assertThat((Map)wi.getParameters()).containsKey((Object)"person");
        Assertions.assertThat((Map)wi.getParameters()).extracting("person").isEqualTo((Object)person);
        processInstance.completeWorkItem(((WorkItem)tasks.get(0)).getId(), new HashMap<String, Person>(Collections.singletonMap("person", new Person("mary", 20))), new Policy[0]);
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }
}

