/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.process.ProcessCodegenException;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;

public class ServiceTaskTest
extends AbstractCodegenTest {
    @Test
    public void testBasicServiceProcessTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/ServiceProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ServiceProcess");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("s", "john");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((Date)processInstance.startDate()).isNotNull();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"s"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("s")).isNotNull()).isEqualTo((Object)"Hello john!");
    }

    @Test
    public void testServiceProcessDifferentOperationsTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/ServiceProcessDifferentOperations.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ServiceProcessDifferentOperations");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("s", "john");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((Date)processInstance.startDate()).isNotNull();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"s"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("s")).isNotNull()).isEqualTo((Object)"Goodbye Hello john!!");
    }

    @Test
    public void testServiceProcessDifferentOperationsTaskFromAnotherNode() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/ServiceProcessDifferentOperations.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ServiceProcessDifferentOperations");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("s", "john");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.startFrom("_A1EE8114-BF7B-4DAF-ABD7-62EEDCFAEFD4");
        Assertions.assertThat((Date)processInstance.startDate()).isNotNull();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"s"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("s")).isNotNull()).isEqualTo((Object)"Goodbye john!");
    }

    @Test
    public void testServiceProcessSameOperationsTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/ServiceProcessSameOperations.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ServiceProcessSameOperations");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("s", "john");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"s"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("s")).isNotNull()).isEqualTo((Object)"Hello Hello john!!");
    }

    @Test
    public void testBasicServiceProcessTaskMultiinstance() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/ServiceProcessMI.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ServiceProcess");
        ArrayList<String> list = new ArrayList<String>();
        list.add("first");
        list.add("second");
        ArrayList listOut = new ArrayList();
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        parameters.put("list", list);
        parameters.put("listOut", listOut);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(3)).containsKeys((Object[])new String[]{"list", "s", "listOut"});
        ((ListAssert)((ListAssert)Assertions.assertThat((List)((List)result.toMap().get("listOut"))).isNotNull()).hasSize(2)).contains((Object[])new String[]{"Hello first!", "Hello second!"});
    }

    @Test
    public void malformedShouldThrowException() throws Exception {
        org.junit.jupiter.api.Assertions.assertThrows(ProcessCodegenException.class, () -> this.generateCodeProcessesOnly("servicetask/ServiceProcessMalformed.bpmn2"));
    }

    @Test
    public void shouldInferMethodSignatureFromClass() throws Exception {
        this.generateCodeProcessesOnly("servicetask/ServiceProcessInferMethod.bpmn2");
    }

    @Test
    public void testMultiParamServiceProcessTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/MultiParamServiceProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ServiceProcess");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("s", "john");
        parameters.put("x", "doe");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKeys((Object[])new String[]{"s", "x"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("s")).isNotNull()).isEqualTo((Object)"Hello (first and lastname) john doe!");
    }

    @Test
    public void testMultiParamConstantServiceProcessTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/MultiParamServiceProcessConstant.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ServiceProcess");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("s", "john");
        parameters.put("x", "doe");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKeys((Object[])new String[]{"s", "x"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("s")).isNotNull()).isEqualTo((Object)"Hello (first and lastname) john Test!");
    }

    @Test
    public void testMultiParamServiceProcessTaskNoOutput() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/MultiParamServiceProcessNoOutput.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("MultiParamServiceProcessNoOutput");
        Model m = (Model)p.createModel();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", "john");
        parameters.put("age", 35);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKeys((Object[])new String[]{"name", "age"});
    }

    @Test
    public void testMultiParamServiceCustomResultProcessTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/MultiParamCustomResultServiceTask.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("services");
        Model m = (Model)p.createModel();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", "john");
        parameters.put("age", 35);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(3)).containsKeys((Object[])new String[]{"name", "age"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("result")).isNotNull()).isEqualTo((Object)"Hello john 35!");
    }

    @Test
    public void testOverloadedService() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/ServiceProcessOverloaded.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ServiceProcessOverloaded");
        ProcessInstance processInstance = p.createInstance((Model)p.createModel());
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }
}

