/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.Path;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessWorkItemTransitionEvent;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.VariableViolationException;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.InvalidTransitionException;
import org.kie.kogito.process.workitem.NotAuthorizedException;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.identity.StaticIdentityProvider;

public class UserTaskTest
extends AbstractCodegenTest {
    private Policy<?> securityPolicy = SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"));

    @Test
    public void testBasicUserTaskProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        final ArrayList workItemTransitionEvents = new ArrayList();
        app.config().process().processEventListeners().listeners().add(new DefaultProcessEventListener(){

            public void beforeWorkItemTransition(ProcessWorkItemTransitionEvent event) {
                workItemTransitionEvents.add("BEFORE:: " + event);
            }

            public void afterWorkItemTransition(ProcessWorkItemTransitionEvent event) {
                workItemTransitionEvents.add("AFTER:: " + event);
            }
        });
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)((WorkItem)workItems.get(0)).getName());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)((WorkItem)workItems.get(0)).getName());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Assertions.assertThat(workItemTransitionEvents).hasSize(8);
    }

    @Test
    public void testBasicUserTaskProcessPhases() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        String workItemId = ((WorkItem)workItems.get(0)).getId();
        processInstance.transitionWorkItem(workItemId, (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testBasicUserTaskProcessClaimAndCompletePhases() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("claim", Collections.singletonMap("test", "value"), new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"claim", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Reserved", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)wi.getResults().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", wi.getResults().get("test"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", wi.getResults().get("ActorId"));
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.abort();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(3);
    }

    @Test
    public void testBasicUserTaskProcessReleaseAndCompletePhases() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        String wiId = wi.getId();
        org.junit.jupiter.api.Assertions.assertThrows(InvalidTransitionException.class, () -> processInstance.transitionWorkItem(wiId, (Transition)new HumanTaskTransition("release", null, new Policy[]{this.securityPolicy})));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.abort();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(3);
    }

    @Test
    public void testBasicUserTaskProcessClaimAndCompletePhasesWithIdentity() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        final ArrayList workItemTransitionEvents = new ArrayList();
        app.config().process().processEventListeners().listeners().add(new DefaultProcessEventListener(){

            public void beforeWorkItemTransition(ProcessWorkItemTransitionEvent event) {
                workItemTransitionEvents.add("BEFORE:: " + event);
            }

            public void afterWorkItemTransition(ProcessWorkItemTransitionEvent event) {
                workItemTransitionEvents.add("AFTER:: " + event);
            }
        });
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("claim", Collections.singletonMap("test", "value"), new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"claim", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Reserved", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)wi.getResults().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", wi.getResults().get("test"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", wi.getResults().get("ActorId"));
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.abort();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(3);
        Assertions.assertThat(workItemTransitionEvents).hasSize(10);
    }

    @Test
    public void testBasicUserTaskProcessClaimAndCompleteWrongUser() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        String wiId = wi.getId();
        StaticIdentityProvider identity = new StaticIdentityProvider("kelly");
        List securedWorkItems = processInstance.workItems(new Policy[]{SecurityPolicy.of((IdentityProvider)identity)});
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)securedWorkItems.size());
        org.junit.jupiter.api.Assertions.assertThrows(WorkItemNotFoundException.class, () -> UserTaskTest.lambda$testBasicUserTaskProcessClaimAndCompleteWrongUser$1(processInstance, wiId, (IdentityProvider)identity));
        org.junit.jupiter.api.Assertions.assertThrows(NotAuthorizedException.class, () -> UserTaskTest.lambda$testBasicUserTaskProcessClaimAndCompleteWrongUser$2(processInstance, wiId, (IdentityProvider)identity));
        org.junit.jupiter.api.Assertions.assertThrows(NotAuthorizedException.class, () -> UserTaskTest.lambda$testBasicUserTaskProcessClaimAndCompleteWrongUser$3(processInstance, wiId, (IdentityProvider)identity));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        StaticIdentityProvider identityCorrect = new StaticIdentityProvider("john");
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, (IdentityProvider)identityCorrect));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.abort();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(3);
    }

    @Test
    public void testApprovalWithExcludedOwnerViaPhases() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/approval.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("approvals");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        StaticIdentityProvider identity = new StaticIdentityProvider("admin", Collections.singletonList("managers"));
        SecurityPolicy policy = SecurityPolicy.of((IdentityProvider)identity);
        processInstance.workItems(new Policy[]{policy});
        List workItems = processInstance.workItems(new Policy[]{policy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        HumanTaskTransition transition = new HumanTaskTransition("complete", null, (IdentityProvider)identity);
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)transition);
        workItems = processInstance.workItems(new Policy[]{policy});
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)workItems.size());
        identity = new StaticIdentityProvider("john", Collections.singletonList("managers"));
        policy = SecurityPolicy.of((IdentityProvider)identity);
        workItems = processInstance.workItems(new Policy[]{policy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        transition = new HumanTaskTransition("complete", null, (IdentityProvider)identity);
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)transition);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testApprovalWithExcludedOwner() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/approval.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("approvals");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        StaticIdentityProvider identity = new StaticIdentityProvider("admin", Collections.singletonList("managers"));
        SecurityPolicy policy = SecurityPolicy.of((IdentityProvider)identity);
        processInstance.workItems(new Policy[]{policy});
        List workItems = processInstance.workItems(new Policy[]{policy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{policy});
        workItems = processInstance.workItems(new Policy[]{policy});
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)workItems.size());
        identity = new StaticIdentityProvider("john", Collections.singletonList("managers"));
        policy = SecurityPolicy.of((IdentityProvider)identity);
        workItems = processInstance.workItems(new Policy[]{policy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{policy});
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testRESTApiForUserTasks() throws Exception {
        class Dummy {
            Dummy() {
            }

            @Path(value="/{id}/FirstTask/{workItemId}")
            void post1() {
            }

            @Path(value="/{id}/SecondTask/{workItemId}")
            void post2() {
            }
        }
        Path firstTask = Dummy.class.getDeclaredMethod("post1", new Class[0]).getAnnotation(Path.class);
        Path secondTask = Dummy.class.getDeclaredMethod("post2", new Class[0]).getAnnotation(Path.class);
        this.testRESTApiForUserTasks("Path", (Annotation)firstTask, (Annotation)secondTask);
    }

    public final void testRESTApiForUserTasks(String postPathAnnotation, Annotation firstTask, Annotation secondTask) throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Class<?> resourceClazz = Class.forName("org.kie.kogito.test.UserTasksProcessResource", true, this.testClassLoader());
        org.junit.jupiter.api.Assertions.assertNotNull(resourceClazz);
        ArrayList completeTaskPaths = new ArrayList();
        Method[] methods = resourceClazz.getMethods();
        Stream.of(methods).filter(m -> m.getName().startsWith("completeTask")).map(AccessibleObject::getAnnotations).flatMap(Stream::of).filter(a -> a.annotationType().getSimpleName().equals(postPathAnnotation)).forEach(completeTaskPaths::add);
        ((ListAssert)Assertions.assertThat(completeTaskPaths).hasSize(2)).containsOnly((Object[])new Annotation[]{firstTask, secondTask});
    }

    @Test
    public void testBasicUserTaskProcessCancelAndTriggerNode() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        String firstSecondTaskNodeInstanceId = wi.getNodeInstanceId();
        processInstance.cancelNodeInstance(wi.getNodeInstanceId());
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.triggerNode("UserTask_2");
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)firstSecondTaskNodeInstanceId, (Object)wi.getNodeInstanceId());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testBasicUserTaskProcessCancelAndRetriggerNode() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        String firstSecondTaskNodeInstanceId = wi.getNodeInstanceId();
        processInstance.retriggerNodeInstance(wi.getNodeInstanceId());
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)firstSecondTaskNodeInstanceId, (Object)wi.getNodeInstanceId());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testBasicUserTaskProcessClaimReleaseClaimAndCompletePhases() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("claim", Collections.singletonMap("test", "value"), new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"claim", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Reserved", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)wi.getResults().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", wi.getResults().get("test"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", wi.getResults().get("ActorId"));
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("release", null, new Policy[]{this.securityPolicy}));
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"release", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)wi.getResults().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", wi.getResults().get("test"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", wi.getResults().get("ActorId"));
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("claim", Collections.singletonMap("test", "value"), new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"claim", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Reserved", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)wi.getResults().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", wi.getResults().get("test"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", wi.getResults().get("ActorId"));
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.abort();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(3);
    }

    @Test
    public void testApprovalWithReadonlyVariableTags() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/approval-with-readonly-variable-tags.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Class<?> resourceClazz = Class.forName("org.acme.travels.ApprovalsModel", true, this.testClassLoader());
        org.junit.jupiter.api.Assertions.assertNotNull(resourceClazz);
        Field approverField = resourceClazz.getDeclaredField("approver");
        Assertions.assertThat((Object)approverField).isNotNull();
        Assertions.assertThat((String)approverField.getType().getCanonicalName()).isEqualTo(String.class.getCanonicalName());
        Process p = app.processes().processById("approvals");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "john");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        Model updates = (Model)p.createModel();
        parameters = new HashMap();
        parameters.put("approver", "mary");
        updates.fromMap(parameters);
        org.junit.jupiter.api.Assertions.assertThrows(VariableViolationException.class, () -> processInstance.updateVariables((Object)updates));
        processInstance.abort();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)processInstance.status());
    }

    @Test
    public void testApprovalWithInternalVariableTags() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/approval-with-internal-variable-tags.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Class<?> resourceClazz = Class.forName("org.acme.travels.ApprovalsModel", true, this.testClassLoader());
        org.junit.jupiter.api.Assertions.assertNotNull(resourceClazz);
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchFieldException.class, () -> resourceClazz.getDeclaredField("approver"));
        Process p = app.processes().processById("approvals");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        processInstance.abort();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)processInstance.status());
    }

    @Test
    public void testApprovalWithRequiredVariableTags() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/approval-with-required-variable-tags.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("approvals");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        org.junit.jupiter.api.Assertions.assertThrows(VariableViolationException.class, () -> {
            ProcessInstance processInstance = p.createInstance(m);
            processInstance.start();
        });
    }

    @Test
    public void testApprovalWithIOVariableTags() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/approval-with-io-variable-tags.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Class<?> modelClazz = Class.forName("org.acme.travels.ApprovalsModel", true, this.testClassLoader());
        org.junit.jupiter.api.Assertions.assertNotNull(modelClazz);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)modelClazz.getDeclaredField("decision"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)modelClazz.getDeclaredField("approver"));
        Class<?> inputModelClazz = Class.forName("org.acme.travels.ApprovalsModelInput", true, this.testClassLoader());
        org.junit.jupiter.api.Assertions.assertNotNull(inputModelClazz);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)inputModelClazz.getDeclaredField("approver"));
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchFieldException.class, () -> inputModelClazz.getDeclaredField("decision"));
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchFieldException.class, () -> inputModelClazz.getDeclaredField("id"));
        Class<?> outputModelClazz = Class.forName("org.acme.travels.ApprovalsModelOutput", true, this.testClassLoader());
        org.junit.jupiter.api.Assertions.assertNotNull(outputModelClazz);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)outputModelClazz.getDeclaredField("decision"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)outputModelClazz.getDeclaredField("id"));
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchFieldException.class, () -> outputModelClazz.getDeclaredField("approver"));
        Process p = app.processes().processById("approvals");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "mary");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        processInstance.abort();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)processInstance.status());
    }

    @Test
    public void testUserTaskWithIOexpressionProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTaskWithIOexpression.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTask");
        Model m = (Model)p.createModel();
        HashMap<String, Person> parameters = new HashMap<String, Person>();
        parameters.put("person", new Person("john", 0));
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hello", (Object)((WorkItem)workItems.get(0)).getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", ((WorkItem)workItems.get(0)).getParameters().get("personName"));
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), Collections.singletonMap("personAge", 50), new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model output = (Model)processInstance.variables();
        Person person = (Person)output.toMap().get("person");
        org.junit.jupiter.api.Assertions.assertEquals((int)50, (int)person.getAge());
    }

    @Test
    public void testBasicUserTaskProcessWithBusinessKey() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        String businessKey = "business key";
        ProcessInstance processInstance = p.createInstance(businessKey, m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.businessKey()).isEqualTo(businessKey);
        Optional processInstanceByBussinesKey = p.instances().findById(processInstance.id());
        Assertions.assertThat((boolean)processInstanceByBussinesKey.isPresent()).isTrue();
        Assertions.assertThat((String)((ProcessInstance)processInstanceByBussinesKey.get()).businessKey()).isEqualTo(businessKey);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)((WorkItem)workItems.get(0)).getName());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)((WorkItem)workItems.get(0)).getName());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testBasicUserTaskProcessWithDuplicatedBusinessKey() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        String businessKey = "business key";
        ProcessInstance processInstance = p.createInstance(businessKey, m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.businessKey()).isEqualTo(businessKey);
        ProcessInstance otherProcessInstance = p.createInstance(businessKey, m);
        Assertions.assertThat((String)otherProcessInstance.id()).isNotEqualTo((Object)processInstance.id());
        Assertions.assertThat((String)otherProcessInstance.businessKey()).isEqualTo(processInstance.businessKey()).isEqualTo(businessKey);
    }

    private static /* synthetic */ void lambda$testBasicUserTaskProcessClaimAndCompleteWrongUser$3(ProcessInstance processInstance, String wiId, IdentityProvider identity) throws Throwable {
        processInstance.completeWorkItem(wiId, null, new Policy[]{SecurityPolicy.of((IdentityProvider)identity)});
    }

    private static /* synthetic */ void lambda$testBasicUserTaskProcessClaimAndCompleteWrongUser$2(ProcessInstance processInstance, String wiId, IdentityProvider identity) throws Throwable {
        processInstance.transitionWorkItem(wiId, (Transition)new HumanTaskTransition("claim", null, identity));
    }

    private static /* synthetic */ void lambda$testBasicUserTaskProcessClaimAndCompleteWrongUser$1(ProcessInstance processInstance, String wiId, IdentityProvider identity) throws Throwable {
        processInstance.workItem(wiId, new Policy[]{SecurityPolicy.of((IdentityProvider)identity)});
    }
}

