/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen;

import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.StaticConfig;
import org.kie.kogito.codegen.ConfigGenerator;
import org.kie.kogito.codegen.process.config.ProcessConfigGenerator;
import org.mockito.Mockito;

public class ConfigGeneratorTest {
    @Test
    public void withProcessConfig() {
        ConfigGenerator generator = new ConfigGenerator();
        ProcessConfigGenerator processConfigGenerator = (ProcessConfigGenerator)Mockito.mock(ProcessConfigGenerator.class);
        ConfigGenerator returnedConfigGenerator = generator.withProcessConfig(processConfigGenerator);
        Assertions.assertThat((Object)returnedConfigGenerator).isNotNull();
        Assertions.assertThat((Object)returnedConfigGenerator).isSameAs((Object)generator);
    }

    @Test
    public void withProcessConfigNull() {
        ConfigGenerator generator = new ConfigGenerator();
        ConfigGenerator returnedConfigGenerator = generator.withProcessConfig(null);
        Assertions.assertThat((Object)returnedConfigGenerator).isNotNull();
        Assertions.assertThat((Object)returnedConfigGenerator).isSameAs((Object)generator);
    }

    @Test
    public void newInstanceNoProcessConfig() {
        this.newInstanceTest(null, NullLiteralExpr.class);
    }

    @Test
    public void newInstanceWithProcessConfig() {
        ProcessConfigGenerator processConfigGenerator = (ProcessConfigGenerator)Mockito.mock(ProcessConfigGenerator.class);
        Mockito.when((Object)processConfigGenerator.newInstance()).thenReturn((Object)new ObjectCreationExpr());
        this.newInstanceTest(processConfigGenerator, ObjectCreationExpr.class);
    }

    private void newInstanceTest(ProcessConfigGenerator processConfigGenerator, Class expectedArgumentType) {
        ObjectCreationExpr expression = new ConfigGenerator().withProcessConfig(processConfigGenerator).newInstance();
        Assertions.assertThat((Object)expression).isNotNull();
        Assertions.assertThat((Object)expression.getType()).isNotNull();
        Assertions.assertThat((String)expression.getType().asString()).isEqualTo((Object)StaticConfig.class.getCanonicalName());
        Assertions.assertThat((List)expression.getArguments()).isNotNull();
        Assertions.assertThat((List)expression.getArguments()).hasSize(2);
        Assertions.assertThat((Object)expression.getArgument(0)).isInstanceOf(expectedArgumentType);
    }
}

