/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen;

import java.util.Arrays;
import java.util.concurrent.Future;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Executor;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.data.AdultUnit;
import org.kie.kogito.codegen.data.AdultUnitModify;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.rules.DataHandle;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitInstance;
import org.kie.kogito.rules.RuleUnitMemory;
import org.kie.kogito.rules.impl.RuleUnitRegistry;

public class RuleUnitCompilerTest
extends AbstractCodegenTest {
    @Test
    public void testRuleUnit() throws Exception {
        this.generateCodeRulesOnly("org/kie/kogito/codegen/data/RuleUnit.drl");
        AdultUnit adults = new AdultUnit();
        adults.getPersons().add((Object)new Person("Mario", 45));
        adults.getPersons().add((Object)new Person("Marilena", 47));
        Person sofia = new Person("Sofia", 7);
        DataHandle dhSofia = adults.getPersons().add((Object)sofia);
        RuleUnit unit = RuleUnitRegistry.create(AdultUnit.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitMemory)adults);
        Assertions.assertEquals((int)2, (int)instance.fire());
        Assertions.assertTrue((boolean)adults.getResults().getResults().containsAll(Arrays.asList("Mario", "Marilena")));
        sofia.setAge(22);
        adults.getPersons().update(dhSofia, (Object)sofia);
        Assertions.assertEquals((int)1, (int)instance.fire());
        Assertions.assertTrue((boolean)adults.getResults().getResults().containsAll(Arrays.asList("Mario", "Marilena", "Sofia")));
    }

    @Test
    public void testRuleUnitModify() throws Exception {
        this.generateCodeRulesOnly("org/kie/kogito/codegen/data/RuleUnitModify.drl");
        AdultUnitModify adults = new AdultUnitModify();
        Person sofia = new Person("Sofia", 7);
        DataHandle dhSofia = adults.getPersons().add((Object)sofia);
        RuleUnit unit = RuleUnitRegistry.create(AdultUnitModify.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitMemory)adults);
        Assertions.assertEquals((int)2, (int)instance.fire());
        Assertions.assertTrue((boolean)adults.getResults().getResults().containsAll(Arrays.asList("Sofia")));
    }

    @Test
    public void testRuleUnitExecutor() throws Exception {
        this.generateCodeRulesOnly("org/kie/kogito/codegen/data/RuleUnit.drl");
        AdultUnit adults = new AdultUnit();
        adults.getPersons().add((Object)new Person("Mario", 45));
        adults.getPersons().add((Object)new Person("Marilena", 47));
        adults.getPersons().add((Object)new Person("Sofia", 7));
        RuleUnitInstance instance = RuleUnitRegistry.instance((RuleUnitMemory)adults);
        Executor executor = Executor.create();
        Future done = executor.submit(instance);
        Assertions.assertEquals((int)2, (int)((Integer)done.get()));
        Assertions.assertTrue((boolean)adults.getResults().getResults().containsAll(Arrays.asList("Mario", "Marilena")));
    }
}

