/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;

public class ServiceTaskTest
extends AbstractCodegenTest {
    @Test
    public void testBasicServiceProcessTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/ServiceProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ServiceProcess");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("s", "john");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"s"});
        ((AbstractObjectAssert)Assertions.assertThat(result.toMap().get("s")).isNotNull()).isEqualTo((Object)"Hello john!");
    }

    @Test
    public void testServiceProcessDifferentOperationsTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/ServiceProcessDifferentOperations.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ServiceProcessDifferentOperations");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("s", "john");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"s"});
        ((AbstractObjectAssert)Assertions.assertThat(result.toMap().get("s")).isNotNull()).isEqualTo((Object)"Goodbye Hello john!!");
    }

    @Test
    public void testServiceProcessSameOperationsTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/ServiceProcessSameOperations.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ServiceProcessSameOperations");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("s", "john");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"s"});
        ((AbstractObjectAssert)Assertions.assertThat(result.toMap().get("s")).isNotNull()).isEqualTo((Object)"Hello Hello john!!");
    }

    @Test
    public void testBasicServiceProcessTaskMultiinstance() throws Exception {
        Application app = this.generateCodeProcessesOnly("servicetask/ServiceProcessMI.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("ServiceProcess");
        ArrayList<String> list = new ArrayList<String>();
        list.add("first");
        list.add("second");
        ArrayList listOut = new ArrayList();
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        parameters.put("list", list);
        parameters.put("listOut", listOut);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(3)).containsKeys((Object[])new String[]{"list", "s", "listOut"});
        ((ListAssert)((ListAssert)Assertions.assertThat((List)((List)result.toMap().get("listOut"))).isNotNull()).hasSize(2)).contains((Object[])new String[]{"Hello first!", "Hello second!"});
    }
}

