/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;

public class UserTaskTest
extends AbstractCodegenTest {
    @Test
    public void testBasicUserTaskProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)((WorkItem)workItems.get(0)).getName());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId().longValue(), null);
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)((WorkItem)workItems.get(0)).getName());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId().longValue(), null);
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testRESTApiForUserTasks() throws Exception {
        Method[] methods;
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Class<?> resourceClazz = Class.forName("org.kie.kogito.test.UserTasksProcessResource", true, this.testClassLoader());
        org.junit.jupiter.api.Assertions.assertNotNull(resourceClazz);
        LinkedHashSet<String> completeTaskPaths = new LinkedHashSet<String>();
        for (Method m : methods = resourceClazz.getMethods()) {
            Annotation[] annotations;
            if (!m.getName().startsWith("completeTask")) continue;
            for (Annotation annotation : annotations = m.getAnnotations()) {
                if (!annotation.annotationType().getSimpleName().equals("Path")) continue;
                completeTaskPaths.add(annotation.toString().replaceAll("\\\"", ""));
            }
        }
        ((IterableAssert)Assertions.assertThat(completeTaskPaths).hasSize(2)).containsOnly((Object[])new String[]{"@javax.ws.rs.Path(value=/{id}/FirstTask/{workItemId})", "@javax.ws.rs.Path(value=/{id}/SecondTask/{workItemId})"});
    }
}

