/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence.proto;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.data.PersonWithAddress;
import org.kie.kogito.codegen.data.PersonWithAddresses;
import org.kie.kogito.codegen.process.persistence.proto.Proto;
import org.kie.kogito.codegen.process.persistence.proto.ProtoField;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoMessage;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

public class ReflectionProtoGeneratorTest {
    private ProtoGenerator<Class<?>> generator = new ReflectionProtoGenerator();

    @Test
    public void testPersonProtoFile() {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(Person.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo((Object)"org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo((Object)"proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo((Object)"Person");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo((Object)"org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(3);
        ProtoField field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"adult");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"age");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"name");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
    }

    @Test
    public void testPersonWithAddressProtoFile() {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(PersonWithAddress.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo((Object)"org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo((Object)"proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        ProtoMessage address = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)address).isNotNull();
        Assertions.assertThat((String)address.getName()).isEqualTo((Object)"Address");
        Assertions.assertThat((String)address.getJavaPackageOption()).isEqualTo((Object)"org.kie.kogito.codegen.data");
        Assertions.assertThat((List)address.getFields()).hasSize(4);
        ProtoField field = (ProtoField)address.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"city");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        field = (ProtoField)address.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"country");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        field = (ProtoField)address.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"street");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        field = (ProtoField)address.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"zipCode");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(1);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo((Object)"PersonWithAddress");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo((Object)"org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(4);
        field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"address");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"Address");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"adult");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"age");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        field = (ProtoField)person.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"name");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
    }

    @Test
    public void testPersonWithAddressesProtoFile() {
        Proto proto = this.generator.generate("org.kie.kogito.test", Collections.singleton(PersonWithAddresses.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo((Object)"org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo((Object)"proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        ProtoMessage address = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)address).isNotNull();
        Assertions.assertThat((String)address.getName()).isEqualTo((Object)"Address");
        Assertions.assertThat((String)address.getJavaPackageOption()).isEqualTo((Object)"org.kie.kogito.codegen.data");
        Assertions.assertThat((List)address.getFields()).hasSize(4);
        ProtoField field = (ProtoField)address.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"city");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        field = (ProtoField)address.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"country");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        field = (ProtoField)address.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"street");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        field = (ProtoField)address.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"zipCode");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(1);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo((Object)"PersonWithAddresses");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo((Object)"org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(4);
        field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"addresses");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"Address");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"repeated");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"adult");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"age");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        field = (ProtoField)person.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"name");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
    }

    @Test
    public void testPersonAsModelProtoFile() {
        Proto proto = this.generator.generate("@Indexed", "@Field(store = Store.YES, analyze = Analyze.YES)", "org.kie.kogito.test.persons", Person.class, new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo((Object)"org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo((Object)"proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo((Object)"Person");
        Assertions.assertThat((String)person.getComment()).isEqualTo((Object)"@Indexed");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo((Object)"org.kie.kogito.test.persons");
        Assertions.assertThat((List)person.getFields()).hasSize(3);
        ProtoField field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"adult");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo((Object)"@Field(store = Store.YES, analyze = Analyze.YES)");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"age");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo((Object)"@Field(store = Store.YES, analyze = Analyze.YES)");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)"name");
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)"string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo((Object)"optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo((Object)"@Field(store = Store.YES, analyze = Analyze.YES)");
    }
}

