/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.rules;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.io.ResourceType;
import org.kie.kogito.codegen.rules.IncrementalRuleCodegen;

public class IncrementalRuleCodegenTest {
    @Test
    public void generateSingleFile() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofFiles(Collections.singleton(new File("src/test/resources/org/kie/kogito/codegen/rules/pkg1/file1.drl")), (ResourceType)ResourceType.DRL);
        incrementalRuleCodegen.setPackageName("com.acme");
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        IncrementalRuleCodegenTest.assertRules(2, 1, generatedFiles.size());
    }

    @Test
    public void generateSinglePackage() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofFiles(Arrays.asList(new File("src/test/resources/org/kie/kogito/codegen/rules/pkg1").listFiles()), (ResourceType)ResourceType.DRL);
        incrementalRuleCodegen.setPackageName("com.acme");
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        IncrementalRuleCodegenTest.assertRules(4, 1, generatedFiles.size());
    }

    @Test
    public void generateDirectoryRecursively() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofPath((Path)Paths.get("src/test/resources/org/kie/kogito/codegen/rules", new String[0]), (ResourceType)ResourceType.DRL);
        incrementalRuleCodegen.setPackageName("com.acme");
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        IncrementalRuleCodegenTest.assertRules(7, 3, 1, generatedFiles.size());
    }

    @Test
    public void generateSingleDtable() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofFiles(Collections.singleton(new File("src/test/resources/org/drools/simple/candrink/CanDrink.xls")));
        incrementalRuleCodegen.setPackageName("com.acme");
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        IncrementalRuleCodegenTest.assertRules(2, 1, generatedFiles.size());
    }

    @Test
    public void generateSingleUnit() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofPath((Path)Paths.get("src/test/resources/org/kie/kogito/codegen/rules/myunit", new String[0]), (ResourceType)ResourceType.DRL);
        incrementalRuleCodegen.setPackageName("com.acme");
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        IncrementalRuleCodegenTest.assertRules(1, 1, 1, generatedFiles.size());
    }

    @Test
    public void generateCepRule() {
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofFiles(Collections.singleton(new File("src/test/resources/org/drools/simple/cep/cep.drl")));
        incrementalRuleCodegen.setPackageName("com.acme");
        List generatedFiles = incrementalRuleCodegen.withHotReloadMode().generate();
        IncrementalRuleCodegenTest.assertRules(1, 1, generatedFiles.size());
    }

    private static void assertRules(int expectedRules, int expectedPackages, int expectedUnits, int actualGeneratedFiles) {
        Assertions.assertEquals((int)(expectedRules + expectedPackages * 2 + expectedUnits * 3 + 1), (int)actualGeneratedFiles);
    }

    private static void assertRules(int expectedRules, int expectedPackages, int actualGeneratedFiles) {
        Assertions.assertEquals((int)(expectedRules + expectedPackages * 2), (int)actualGeneratedFiles);
    }
}

