/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.drools.core.config.DefaultRuleEventListenerConfig;
import org.drools.core.event.DefaultAgendaEventListener;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;
import org.kie.kogito.uow.UnitOfWork;

public class BusinessRuleUnitTest
extends AbstractCodegenTest {
    static Stream<String> processes() {
        return Stream.of("org/kie/kogito/codegen/tests/BusinessRuleUnit.bpmn2", "org/kie/kogito/codegen/tests/BusinessRuleUnitAlternateSyntax.bpmn2");
    }

    @ParameterizedTest
    @MethodSource(value={"processes"})
    public void testBasicBusinessRuleUnit(String bpmnPath) throws Exception {
        Application app = this.generateCode(Collections.singletonList(bpmnPath), Collections.singletonList("org/kie/kogito/codegen/tests/BusinessRuleUnit.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("BusinessRuleUnit");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((AbstractObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
    }

    @ParameterizedTest
    @MethodSource(value={"processes"})
    public void testBasicBusinessRuleUnitWithAgendaListener(String bpmnPath) throws Exception {
        Application app = this.generateCode(Collections.singletonList(bpmnPath), Collections.singletonList("org/kie/kogito/codegen/tests/BusinessRuleUnit.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        final AtomicInteger counter = new AtomicInteger();
        ((DefaultRuleEventListenerConfig)app.config().rule().ruleEventListeners()).register((AgendaEventListener)new DefaultAgendaEventListener(){

            public void afterMatchFired(AfterMatchFiredEvent event) {
                counter.incrementAndGet();
            }
        });
        Process p = app.processes().processById("BusinessRuleUnit");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((AbstractObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
        Assertions.assertThat((int)counter.get()).isEqualTo(1);
    }

    @ParameterizedTest
    @MethodSource(value={"processes"})
    public void testBasicBusinessRuleUnitControlledByUnitOfWork(String bpmnPath) throws Exception {
        Application app = this.generateCode(Collections.singletonList(bpmnPath), Collections.singletonList("org/kie/kogito/codegen/tests/BusinessRuleUnit.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        final ArrayList startedProcesses = new ArrayList();
        ((DefaultProcessEventListenerConfig)app.config().process().processEventListeners()).listeners().add(new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                startedProcesses.add(event.getProcessInstance().getId());
            }
        });
        UnitOfWork uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        Process p = app.processes().processById("BusinessRuleUnit");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((AbstractObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
        Assertions.assertThat(startedProcesses).hasSize(0);
        uow.end();
        Assertions.assertThat(startedProcesses).hasSize(1);
    }
}

