/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.uow.UnitOfWork;

public class SignalEventTest
extends AbstractCodegenTest {
    @Test
    public void testIntermediateSignalEventWithData() throws Exception {
        Application app = this.generateCode(Collections.singletonList("signalevent/IntermediateCatchEventSignal.bpmn2"), Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("IntermediateCatchEvent");
        Model m = (Model)p.createModel();
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[0]);
        Assertions.assertThat((List)workItems).hasSize(1);
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[0]);
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.send(Sig.of((String)"MyMessage", (Object)"test"));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKey((Object)"x");
        Assertions.assertThat(result.toMap().get("x")).isEqualTo((Object)"test");
        Assertions.assertThat((Iterable)p.instances().values()).hasSize(0);
    }

    @Test
    public void testBoundarySignalEventWithData() throws Exception {
        Application app = this.generateCode(Collections.singletonList("signalevent/BoundarySignalEventOnTask.bpmn2"), Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("BoundarySignalOnTask");
        Model m = (Model)p.createModel();
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.send(Sig.of((String)"MySignal", (Object)"test"));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"x");
        Assertions.assertThat(result.toMap().get("x")).isEqualTo((Object)"test");
        Assertions.assertThat((Iterable)p.instances().values()).hasSize(0);
    }

    @Test
    public void testIntermediateSignalEventWithDataControlledByUnitOfWork() throws Exception {
        Application app = this.generateCode(Collections.singletonList("signalevent/IntermediateCatchEventSignal.bpmn2"), Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        UnitOfWork uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        Process p = app.processes().processById("IntermediateCatchEvent");
        Model m = (Model)p.createModel();
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((Iterable)p.instances().values()).hasSize(0);
        uow.end();
        Assertions.assertThat((Iterable)p.instances().values()).hasSize(1);
        uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        List workItems = processInstance.workItems(new Policy[0]);
        Assertions.assertThat((List)workItems).hasSize(1);
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[0]);
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        uow.end();
        uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        processInstance.send(Sig.of((String)"MyMessage", (Object)"test"));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKey((Object)"x");
        Assertions.assertThat(result.toMap().get("x")).isEqualTo((Object)"test");
        Assertions.assertThat((Iterable)p.instances().values()).hasSize(1);
        uow.end();
        Assertions.assertThat((Iterable)p.instances().values()).hasSize(0);
    }
}

