/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.metadata;

import java.io.File;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.metadata.PersistenceLabeler;

public class PersistenceLabelerTest {
    @Test
    void testGenerateLabels() throws URISyntaxException {
        PersistenceLabeler labeler = new PersistenceLabeler();
        File protoFile = new File(this.getClass().getResource("/kogito-types.proto").toURI());
        Assertions.assertThat((File)protoFile).isNotNull();
        labeler.processProto(protoFile);
        Map labels = labeler.generateLabels();
        Assertions.assertThat((Map)labels).size().isEqualTo(1);
        Assertions.assertThat((Map)labels).containsKey((Object)labeler.generateKey(protoFile));
    }

    @Test
    void testGenerateLabelsIOException() throws URISyntaxException {
        PersistenceLabeler labeler = new PersistenceLabeler();
        org.junit.jupiter.api.Assertions.assertThrows(UncheckedIOException.class, () -> labeler.processProto(new File("/does/not/exist")));
    }
}

