/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.core.io.impl.ByteArrayResource;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.kogito.codegen.rules.IncrementalRuleCodegen;

public class BigRuleSetCodegenTest {
    @Test
    public void test() {
        Collection<Resource> resources = this.generateResourcesToBeCompiled(2, 3);
        IncrementalRuleCodegen incrementalRuleCodegen = IncrementalRuleCodegen.ofResources(resources);
        List generatedFiles = incrementalRuleCodegen.generate();
        System.out.println(generatedFiles.size());
    }

    private Collection<Resource> generateResourcesToBeCompiled(int numberOfResources, int rulesPerResource) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (int i = 0; i < numberOfResources; ++i) {
            ByteArrayResource resource = new ByteArrayResource(this.generateRules("org.kie.kogito.codegen.test" + i, rulesPerResource).getBytes());
            resource.setResourceType(ResourceType.DRL);
            resource.setSourcePath("org/kie/kogito/codegen/test" + i + "/rules.drl");
            resources.add((Resource)resource);
        }
        return resources;
    }

    private String generateRules(String packageName, int n) {
        StringBuilder sb = new StringBuilder("package " + packageName + "\n");
        for (int i = 0; i < n; ++i) {
            sb.append(this.generateRule(i));
        }
        return sb.toString();
    }

    private String generateRule(int seed) {
        return "rule R" + seed + " when\n  $i: Integer( this == " + seed + " )\n  $s: String( this == $i.toString() )\nthen\n  System.out.println($s);\nend\n";
    }
}

