/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.process.ProcessCodegenException;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.Sig;

public class MessageIntermediateEventTest
extends AbstractCodegenTest {
    @Test
    public void testMessageThrowEventProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("messageevent/IntermediateThrowEventMessage.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("MessageIntermediateEvent");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"customerId"});
    }

    @Test
    public void testMessageCatchEventProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("messageevent/IntermediateCatchEventMessage.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("IntermediateCatchEvent");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.send(Sig.of((String)"Message-customers", (Object)"CUS-00998877"));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"customerId"});
        ((AbstractObjectAssert)Assertions.assertThat(result.toMap().get("customerId")).isNotNull()).isEqualTo((Object)"CUS-00998877");
    }

    @Test
    public void testMessageBoundaryCatchEventProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("messageevent/BoundaryMessageEventOnTask.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("BoundaryMessageOnTask");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.send(Sig.of((String)"Message-customers", (Object)"CUS-00998877"));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"customerId"});
        ((AbstractObjectAssert)Assertions.assertThat(result.toMap().get("customerId")).isNotNull()).isEqualTo((Object)"CUS-00998877");
    }

    @Test
    public void malformedShouldThrowException() {
        org.junit.jupiter.api.Assertions.assertThrows(ProcessCodegenException.class, () -> this.generateCodeProcessesOnly("messageevent/EventNodeMalformed.bpmn2"));
    }
}

