/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.time.OffsetDateTime;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.jbpm.test.util.NodeLeftCountDownProcessEventListener;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;

public class TimerEventTest
extends AbstractCodegenTest {
    @Test
    public void testIntermediateCycleTimerEvent() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/IntermediateCatchEventTimerCycleISO.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("timer", 3);
        ((DefaultProcessEventListenerConfig)app.config().process().processEventListeners()).register((ProcessEventListener)listener);
        Process p = app.processes().processById("IntermediateCatchEvent");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.abort();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(3);
    }

    @Test
    public void testIntermediateDurationTimerEvent() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/IntermediateCatchEventTimerDurationISO.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("timer", 1);
        ((DefaultProcessEventListenerConfig)app.config().process().processEventListeners()).register((ProcessEventListener)listener);
        Process p = app.processes().processById("IntermediateCatchEvent");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testIntermediateDateTimerEvent() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/IntermediateCatchEventTimerDateISO.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("timer", 1);
        ((DefaultProcessEventListenerConfig)app.config().process().processEventListeners()).register((ProcessEventListener)listener);
        Process p = app.processes().processById("IntermediateCatchEvent");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        OffsetDateTime plusTwoSeconds = OffsetDateTime.now().plusSeconds(2L);
        parameters.put("date", plusTwoSeconds.toString());
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testBoundaryDurationTimerEventOnTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/TimerBoundaryEventDurationISOOnTask.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1);
        ((DefaultProcessEventListenerConfig)app.config().process().processEventListeners()).register((ProcessEventListener)listener);
        Process p = app.processes().processById("TimerBoundaryEvent");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testBoundaryCycleTimerEventOnTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/TimerBoundaryEventCycleISOOnTask.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1);
        ((DefaultProcessEventListenerConfig)app.config().process().processEventListeners()).register((ProcessEventListener)listener);
        Process p = app.processes().processById("TimerBoundaryEvent");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testBoundaryDateTimerEventOnTask() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/TimerBoundaryEventDateISOOnTask.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1);
        ((DefaultProcessEventListenerConfig)app.config().process().processEventListeners()).register((ProcessEventListener)listener);
        Process p = app.processes().processById("TimerBoundaryEvent");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        OffsetDateTime plusTwoSeconds = OffsetDateTime.now().plusSeconds(2L);
        parameters.put("date", plusTwoSeconds.toString());
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testBoundaryDurationTimerEventOnSubprocess() throws Exception {
        Application app = this.generateCodeProcessesOnly("timer/TimerBoundaryEventDurationISO.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1);
        ((DefaultProcessEventListenerConfig)app.config().process().processEventListeners()).register((ProcessEventListener)listener);
        Process p = app.processes().processById("TimerBoundaryEvent");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }
}

