/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Config;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.ApplicationSection;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.di.CDIDependencyInjectionAnnotator;
import org.kie.kogito.codegen.di.DependencyInjectionAnnotator;
import org.kie.kogito.codegen.metadata.MetaDataWriter;
import org.kie.kogito.codegen.metadata.PrometheusLabeler;
import org.mockito.Mockito;

public class ApplicationGeneratorTest {
    private static final String PACKAGE_NAME = "org.drools.test";
    private static final String EXPECTED_APPLICATION_NAME = "org.drools.test.Application";

    @Test
    public void targetCanonicalName() {
        ApplicationGenerator appGenerator = new ApplicationGenerator(PACKAGE_NAME, new File(""));
        Assertions.assertThat((String)appGenerator.targetCanonicalName()).isNotNull();
        Assertions.assertThat((String)appGenerator.targetCanonicalName()).isEqualTo(EXPECTED_APPLICATION_NAME);
    }

    @Test
    public void packageNameNull() {
        Assertions.assertThatThrownBy(() -> new ApplicationGenerator(null, new File(""))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void packageNameInvalid() {
        Assertions.assertThatThrownBy(() -> new ApplicationGenerator("i.am.an-invalid.package-name.sorry", new File(""))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void generatedFilePath() {
        ApplicationGenerator appGenerator = new ApplicationGenerator(PACKAGE_NAME, new File(""));
        Assertions.assertThat((String)appGenerator.generatedFilePath()).isNotNull();
        Assertions.assertThat((String)appGenerator.generatedFilePath()).isEqualTo(EXPECTED_APPLICATION_NAME.replace(".", "/") + ".java");
    }

    @Test
    public void compilationUnit() {
        ApplicationGenerator appGenerator = new ApplicationGenerator(PACKAGE_NAME, new File("target"));
        this.assertCompilationUnit(appGenerator.compilationUnit(), false, 4);
    }

    @Test
    public void compilationUnitWithCDI() {
        ApplicationGenerator initialAppGenerator = new ApplicationGenerator(PACKAGE_NAME, new File("target"));
        ApplicationGenerator appGenerator = initialAppGenerator.withDependencyInjection((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator());
        Assertions.assertThat((Object)appGenerator).isSameAs((Object)initialAppGenerator);
        this.assertCompilationUnit(appGenerator.compilationUnit(), true, 4);
    }

    @Test
    public void compilationUnitWithFactoryMethods() {
        ApplicationGenerator appGenerator = new ApplicationGenerator(PACKAGE_NAME, new File("target"));
        String testMethodName = "testMethod";
        MethodDeclaration methodDeclaration = new MethodDeclaration();
        methodDeclaration.setName("testMethod");
        appGenerator.addFactoryMethods(Collections.singleton(methodDeclaration));
        CompilationUnit compilationUnit = appGenerator.compilationUnit();
        this.assertCompilationUnit(compilationUnit, false, 5);
        TypeDeclaration mainAppClass = (TypeDeclaration)compilationUnit.getTypes().get(0);
        Assertions.assertThat((List)mainAppClass.getMembers()).filteredOn(member -> member instanceof MethodDeclaration && ((MethodDeclaration)member).getName().toString().equals("testMethod")).hasSize(1);
    }

    @Test
    public void generate() {
        ApplicationGenerator appGenerator = new ApplicationGenerator(PACKAGE_NAME, new File("target"));
        Collection generatedFiles = appGenerator.generate();
        this.assertGeneratedFiles(generatedFiles, appGenerator.compilationUnit().toString().getBytes(StandardCharsets.UTF_8), 2);
    }

    @Test
    public void generateWithMonitoring() throws IOException {
        Path targetDirectory = Paths.get("target", new String[0]);
        ApplicationGenerator appGenerator = new ApplicationGenerator(PACKAGE_NAME, targetDirectory.toFile()).withMonitoring(true);
        appGenerator.generate();
        this.assertImageMetadata(targetDirectory, new PrometheusLabeler().generateLabels());
    }

    @Test
    public void generateWithOtherGenerator() throws IOException {
        Generator mockGenerator = (Generator)Mockito.mock(Generator.class);
        ApplicationSection appSection = new ApplicationSection(){
            private ClassOrInterfaceDeclaration classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration().setName("Foo");
            private MethodDeclaration methodDeclaration = (MethodDeclaration)new MethodDeclaration().setType("void");
            private FieldDeclaration fieldDeclaration = (FieldDeclaration)new FieldDeclaration().addVariable((VariableDeclarator)((VariableDeclarator)new VariableDeclarator().setType(Integer.TYPE)).setName("i"));

            public FieldDeclaration fieldDeclaration() {
                return this.fieldDeclaration;
            }

            public MethodDeclaration factoryMethod() {
                return this.methodDeclaration;
            }

            public ClassOrInterfaceDeclaration classDeclaration() {
                return this.classOrInterfaceDeclaration;
            }
        };
        Mockito.when((Object)mockGenerator.section()).thenReturn((Object)appSection);
        GeneratedFile generatedFile = (GeneratedFile)Mockito.mock(GeneratedFile.class);
        Mockito.when((Object)generatedFile.getType()).thenReturn((Object)GeneratedFile.Type.RULE);
        Set<GeneratedFile> mockFiles = Collections.singleton(generatedFile);
        Mockito.when((Object)mockGenerator.generate()).thenReturn(mockFiles);
        HashMap<String, String> mockLabels = new HashMap<String, String>();
        mockLabels.put("testKey", "testValue");
        Mockito.when((Object)mockGenerator.getLabels()).thenReturn(mockLabels);
        ApplicationGenerator appGenerator = new ApplicationGenerator(PACKAGE_NAME, new File("target/classes"));
        appGenerator.withGenerator(mockGenerator);
        Collection generatedFiles = appGenerator.generate();
        CompilationUnit compilationUnit = appGenerator.compilationUnit();
        this.assertGeneratedFiles(generatedFiles, compilationUnit.toString().getBytes(StandardCharsets.UTF_8), 3);
        this.assertCompilationUnit(compilationUnit, false, 7);
        TypeDeclaration mainAppClass = (TypeDeclaration)compilationUnit.getTypes().get(0);
        Assertions.assertThat((List)mainAppClass.getMembers()).filteredOn(member -> member == appSection.factoryMethod()).hasSize(1);
        Assertions.assertThat((List)mainAppClass.getMembers()).filteredOn(member -> member == appSection.classDeclaration()).hasSize(1);
        this.assertImageMetadata(Paths.get("target/classes", new String[0]), mockLabels);
    }

    @Test
    public void writeLabelsImageMetadata() throws IOException {
        Path targetDirectory = Paths.get("target", new String[0]);
        ApplicationGenerator appGenerator = new ApplicationGenerator(PACKAGE_NAME, targetDirectory.toFile());
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("testKey1", "testValue1");
        labels.put("testKey2", "testValue2");
        labels.put("testKey3", "testValue3");
        MetaDataWriter.writeLabelsImageMetadata((File)targetDirectory.toFile(), labels);
        this.assertImageMetadata(targetDirectory, labels);
    }

    private void assertImageMetadata(Path directory, Map<String, String> expectedLabels) throws IOException {
        try (Stream<Path> stream = Files.walk(directory, 1, new FileVisitOption[0]);){
            Optional<Path> generatedFile = stream.filter(file -> file.getFileName().toString().equals("image_metadata.json")).findFirst();
            Assertions.assertThat(generatedFile).isPresent();
            ObjectMapper mapper = new ObjectMapper();
            Map elementsFromFile = (Map)mapper.readValue(generatedFile.get().toFile(), (TypeReference)new TypeReference<Map<String, List>>(){});
            Assertions.assertThat((Map)elementsFromFile).hasSize(1);
            List listWithLabelsMap = (List)elementsFromFile.entrySet().iterator().next().getValue();
            Assertions.assertThat((List)listWithLabelsMap).isNotNull();
            Assertions.assertThat((List)listWithLabelsMap).hasSize(1);
            Assertions.assertThat((Map)((Map)listWithLabelsMap.get(0))).containsAllEntriesOf(expectedLabels);
        }
    }

    private void assertCompilationUnit(CompilationUnit compilationUnit, boolean checkCDI) {
        this.assertCompilationUnit(compilationUnit, checkCDI, 0);
    }

    private void assertCompilationUnit(CompilationUnit compilationUnit, boolean checkCDI, int expectedNumberOfCustomFactoryMethods) {
        Assertions.assertThat((Object)compilationUnit).isNotNull();
        Assertions.assertThat((Optional)compilationUnit.getPackageDeclaration()).isPresent();
        Assertions.assertThat((String)((PackageDeclaration)compilationUnit.getPackageDeclaration().get()).getName().toString()).isEqualTo(PACKAGE_NAME);
        Assertions.assertThat((List)compilationUnit.getImports()).isNotNull();
        Assertions.assertThat((List)compilationUnit.getImports()).hasSize(3);
        Assertions.assertThat((String)((ImportDeclaration)compilationUnit.getImports().get(0)).getName().toString()).isEqualTo(Config.class.getCanonicalName());
        Assertions.assertThat((List)compilationUnit.getTypes()).isNotNull();
        Assertions.assertThat((List)compilationUnit.getTypes()).hasSize(1);
        TypeDeclaration mainAppClass = (TypeDeclaration)compilationUnit.getTypes().get(0);
        Assertions.assertThat((Object)mainAppClass).isNotNull();
        Assertions.assertThat((String)mainAppClass.getName().toString()).isEqualTo("Application");
        if (checkCDI) {
            Assertions.assertThat((List)mainAppClass.getAnnotations()).isNotEmpty();
            Assertions.assertThat((Optional)mainAppClass.getAnnotationByName("Singleton")).isPresent();
        } else {
            Assertions.assertThat((Optional)mainAppClass.getAnnotationByName("Singleton")).isNotPresent();
        }
        Assertions.assertThat((List)mainAppClass.getMembers()).isNotNull();
        Assertions.assertThat((List)mainAppClass.getMembers()).hasSize(2 + expectedNumberOfCustomFactoryMethods);
        Assertions.assertThat((List)mainAppClass.getMembers()).filteredOn(member -> member instanceof MethodDeclaration && ((MethodDeclaration)member).getName().toString().equals("config") && !((MethodDeclaration)member).isStatic()).hasSize(1);
        Assertions.assertThat((List)mainAppClass.getMembers()).filteredOn(member -> member instanceof FieldDeclaration && ((FieldDeclaration)member).getVariable(0).getName().toString().equals("config") && ((FieldDeclaration)member).isStatic()).hasSize(0);
        Assertions.assertThat((Object)mainAppClass.getMember(0)).isInstanceOfAny(new Class[]{MethodDeclaration.class, FieldDeclaration.class});
        Assertions.assertThat((Object)mainAppClass.getMember(1)).isInstanceOfAny(new Class[]{MethodDeclaration.class, FieldDeclaration.class});
    }

    private void assertGeneratedFiles(Collection<GeneratedFile> generatedFiles, byte[] expectedApplicationContent, int expectedFilesCount) {
        Assertions.assertThat(generatedFiles).isNotNull();
        Assertions.assertThat(generatedFiles).hasSize(expectedFilesCount);
        for (GeneratedFile generatedFile : generatedFiles) {
            Assertions.assertThat((Object)generatedFile).isNotNull();
            Assertions.assertThat((Comparable)generatedFile.getType()).isIn(new Object[]{GeneratedFile.Type.APPLICATION, GeneratedFile.Type.RULE, GeneratedFile.Type.CLASS});
            if (generatedFile.getType() != GeneratedFile.Type.APPLICATION) continue;
            Assertions.assertThat((String)generatedFile.relativePath()).isEqualTo(EXPECTED_APPLICATION_NAME.replace(".", "/") + ".java");
            Assertions.assertThat((byte[])generatedFile.contents()).isEqualTo((Object)expectedApplicationContent);
        }
    }
}

