/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.time.SessionPseudoClock;
import org.kie.kogito.Application;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.rules.multiunit.MultiUnit;
import org.kie.kogito.codegen.unit.AdultUnit;
import org.kie.kogito.codegen.unit.PersonsUnit;
import org.kie.kogito.rules.DataHandle;
import org.kie.kogito.rules.DataObserver;
import org.kie.kogito.rules.DataSource;
import org.kie.kogito.rules.DataStore;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitData;
import org.kie.kogito.rules.RuleUnitInstance;

public class RuleUnitCompilerTest
extends AbstractCodegenTest {
    @Test
    public void testRuleUnit() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/RuleUnit.drl");
        AdultUnit adults = new AdultUnit();
        adults.getPersons().add((Object)new Person("Mario", 45));
        adults.getPersons().add((Object)new Person("Marilena", 47));
        Person sofia = new Person("Sofia", 7);
        DataHandle dhSofia = adults.getPersons().add((Object)sofia);
        RuleUnit unit = application.ruleUnits().create(AdultUnit.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitData)adults);
        Assertions.assertTrue((boolean)(instance.getClock() instanceof SessionPseudoClock));
        Assertions.assertEquals((int)2, (int)instance.fire());
        Assertions.assertTrue((boolean)adults.getResults().getResults().containsAll(Arrays.asList("Mario", "Marilena")));
        sofia.setAge(22);
        adults.getPersons().update(dhSofia, (Object)sofia);
        Assertions.assertEquals((int)1, (int)instance.fire());
        Assertions.assertTrue((boolean)adults.getResults().getResults().containsAll(Arrays.asList("Mario", "Marilena", "Sofia")));
    }

    @Test
    public void testRuleUnitModify() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/RuleUnitModify.drl");
        AdultUnit adults = new AdultUnit();
        Person sofia = new Person("Sofia", 7);
        DataHandle dhSofia = adults.getPersons().add((Object)sofia);
        RuleUnit unit = application.ruleUnits().create(AdultUnit.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitData)adults);
        Assertions.assertEquals((int)2, (int)instance.fire());
        Assertions.assertTrue((boolean)adults.getResults().getResults().containsAll(Arrays.asList("Sofia")));
    }

    @Test
    public void testRuleUnitDelete() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/RuleUnitDelete.drl");
        AdultUnit adults = new AdultUnit();
        adults.getPersons().add((Object)new Person("Mario", 45));
        adults.getPersons().add((Object)new Person("Marilena", 47));
        adults.getPersons().add((Object)new Person("Sofia", 7));
        RuleUnit unit = application.ruleUnits().create(AdultUnit.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitData)adults);
        instance.fire();
        List<String> results = adults.getResults().getResults();
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertTrue((boolean)results.containsAll(Arrays.asList("Mario", "Marilena")));
    }

    @Test
    public void testRuleUnitQuery() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/RuleUnitQuery.drl");
        AdultUnit adults = new AdultUnit();
        adults.getPersons().add((Object)new Person("Mario", 45));
        adults.getPersons().add((Object)new Person("Marilena", 47));
        adults.getPersons().add((Object)new Person("Sofia", 7));
        RuleUnit unit = application.ruleUnits().create(AdultUnit.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitData)adults);
        List results = instance.executeQuery("FindAdults", new Object[0]).stream().map(m -> m.get("$name")).map(String.class::cast).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertTrue((boolean)results.containsAll(Arrays.asList("Mario", "Marilena")));
    }

    @Test
    public void testRuleUnitQueryOnPrimitive() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/RuleUnitQuery.drl");
        AdultUnit adults = new AdultUnit();
        adults.getPersons().add((Object)new Person("Mario", 45));
        adults.getPersons().add((Object)new Person("Marilena", 47));
        adults.getPersons().add((Object)new Person("Sofia", 7));
        RuleUnit unit = application.ruleUnits().create(AdultUnit.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitData)adults);
        List results = instance.executeQuery("FindAdultsAge", new Object[0]).stream().map(m -> m.get("$age")).map(Integer.class::cast).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertTrue((boolean)results.containsAll(Arrays.asList(45, 47)));
    }

    @Test
    public void testRuleUnitExecutor() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/RuleUnit.drl", "org/kie/kogito/codegen/unit/PersonsUnit.drl");
        DataStore persons = DataSource.createStore();
        persons.add((Object)new Person("Mario", 45));
        persons.add((Object)new Person("Marilena", 17));
        persons.add((Object)new Person("Sofia", 7));
        RuleUnit adultUnit = application.ruleUnits().create(AdultUnit.class);
        AdultUnit adultData18 = new AdultUnit((DataStore<Person>)persons, 18);
        RuleUnitInstance adultUnitInstance18 = adultUnit.createInstance((RuleUnitData)adultData18, "adult18");
        AdultUnit adultData21 = new AdultUnit((DataStore<Person>)persons, 21);
        RuleUnitInstance adultUnitInstance21 = adultUnit.createInstance((RuleUnitData)adultData21, "adult21");
        RuleUnit personsUnit = application.ruleUnits().create(PersonsUnit.class);
        personsUnit.createInstance((RuleUnitData)new PersonsUnit((DataStore<Person>)persons)).fire();
        Assertions.assertEquals((int)2, (int)adultData18.getResults().getResults().size());
        Assertions.assertTrue((boolean)adultData18.getResults().getResults().containsAll(Arrays.asList("Mario", "Marilena")));
        Assertions.assertEquals((int)1, (int)adultData21.getResults().getResults().size());
        Assertions.assertTrue((boolean)adultData21.getResults().getResults().containsAll(Arrays.asList("Mario")));
    }

    @Test
    public void generateSinglePackageSingleUnit() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/rules/multiunit/MultiUnit.drl", "org/kie/kogito/codegen/rules/multiunit/MultiUnit2.drl");
        ArrayList strings = new ArrayList();
        RuleUnit mu = application.ruleUnits().create(MultiUnit.class);
        MultiUnit data = new MultiUnit();
        RuleUnitInstance instance = mu.createInstance((RuleUnitData)data);
        data.getValues().subscribe(DataObserver.of(v -> {
            if (v != null) {
                strings.add((String)v);
            }
        }));
        data.getValues().add((Object)"start");
        instance.fire();
        Assertions.assertEquals(Arrays.asList("start", "middle", "done"), strings);
    }
}

