/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.config.DefaultRuleEventListenerConfig;
import org.drools.core.event.DefaultAgendaEventListener;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;
import org.kie.kogito.uow.UnitOfWork;

public class BusinessRuleTaskTest
extends AbstractCodegenTest {
    @Test
    public void testBasicBusinessRuleTask() throws Exception {
        Application app = this.generateCode(Collections.singletonList("ruletask/BusinessRuleTask.bpmn2"), Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("BusinessRuleTask");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
    }

    @Test
    public void testBasicBusinessRuleTaskWithAgendaListener() throws Exception {
        Application app = this.generateCode(Collections.singletonList("ruletask/BusinessRuleTask.bpmn2"), Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        final AtomicInteger counter = new AtomicInteger();
        ((DefaultRuleEventListenerConfig)app.config().rule().ruleEventListeners()).register((AgendaEventListener)new DefaultAgendaEventListener(){

            public void afterMatchFired(AfterMatchFiredEvent event) {
                counter.incrementAndGet();
            }
        });
        Process p = app.processes().processById("BusinessRuleTask");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
        Assertions.assertThat((int)counter.get()).isEqualTo(1);
    }

    @Test
    public void testBasicBusinessRuleTaskControlledByUnitOfWork() throws Exception {
        Application app = this.generateCode(Collections.singletonList("ruletask/BusinessRuleTask.bpmn2"), Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        final ArrayList startedProcesses = new ArrayList();
        ((DefaultProcessEventListenerConfig)app.config().process().processEventListeners()).listeners().add(new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                startedProcesses.add(event.getProcessInstance().getId());
            }
        });
        UnitOfWork uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        Process p = app.processes().processById("BusinessRuleTask");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
        Assertions.assertThat(startedProcesses).hasSize(0);
        uow.end();
        Assertions.assertThat(startedProcesses).hasSize(1);
    }

    @Test
    public void testDecision() throws Exception {
        Application app = this.generateCode(Collections.singletonList("decision/dmnprocess.bpmn2"), Collections.emptyList(), Collections.singletonList("decision/vacationDaysAlt.dmn"), Collections.emptyList(), false);
        Process p = app.processes().processById("DmnProcess");
        Model m = (Model)p.createModel();
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("age", 16);
        vars.put("yearsOfService", 1);
        m.fromMap(vars);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("vacationDays")).isNotNull()).isEqualTo((Object)BigDecimal.valueOf(27L));
        m = (Model)p.createModel();
        vars = new HashMap();
        vars.put("age", 44);
        vars.put("yearsOfService", 20);
        m.fromMap(vars);
        processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        result = (Model)processInstance.variables();
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("vacationDays")).isNotNull()).isEqualTo((Object)BigDecimal.valueOf(24L));
        m = (Model)p.createModel();
        vars = new HashMap();
        vars.put("age", 50);
        vars.put("yearsOfService", 30);
        m.fromMap(vars);
        processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        result = (Model)processInstance.variables();
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("vacationDays")).isNotNull()).isEqualTo((Object)BigDecimal.valueOf(30L));
    }
}

