/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessWorkItemTransitionEvent;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;
import org.kie.kogito.process.workitem.InvalidTransitionException;
import org.kie.kogito.process.workitem.NotAuthorizedException;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.identity.StaticIdentityProvider;

public class UserTaskTest
extends AbstractCodegenTest {
    private Policy<?> securityPolicy = SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"));

    @Test
    public void testBasicUserTaskProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        final ArrayList workItemTransitionEvents = new ArrayList();
        ((DefaultProcessEventListenerConfig)app.config().process().processEventListeners()).listeners().add(new DefaultProcessEventListener(){

            public void beforeWorkItemTransition(ProcessWorkItemTransitionEvent event) {
                workItemTransitionEvents.add("BEFORE:: " + event);
            }

            public void afterWorkItemTransition(ProcessWorkItemTransitionEvent event) {
                workItemTransitionEvents.add("AFTER:: " + event);
            }
        });
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)((WorkItem)workItems.get(0)).getName());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)((WorkItem)workItems.get(0)).getName());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Assertions.assertThat(workItemTransitionEvents).hasSize(8);
    }

    @Test
    public void testBasicUserTaskProcessPhases() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testBasicUserTaskProcessClaimAndCompletePhases() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("claim", Collections.singletonMap("test", "value"), new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"claim", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Reserved", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)wi.getResults().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", wi.getResults().get("test"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", wi.getResults().get("ActorId"));
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.abort();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(3);
    }

    @Test
    public void testBasicUserTaskProcessReleaseAndCompletePhases() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        String wiId = wi.getId();
        org.junit.jupiter.api.Assertions.assertThrows(InvalidTransitionException.class, () -> processInstance.transitionWorkItem(wiId, (Transition)new HumanTaskTransition("release", null, new Policy[]{this.securityPolicy})));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.abort();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(3);
    }

    @Test
    public void testBasicUserTaskProcessClaimAndCompletePhasesWithIdentity() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        final ArrayList workItemTransitionEvents = new ArrayList();
        ((DefaultProcessEventListenerConfig)app.config().process().processEventListeners()).listeners().add(new DefaultProcessEventListener(){

            public void beforeWorkItemTransition(ProcessWorkItemTransitionEvent event) {
                workItemTransitionEvents.add("BEFORE:: " + event);
            }

            public void afterWorkItemTransition(ProcessWorkItemTransitionEvent event) {
                workItemTransitionEvents.add("AFTER:: " + event);
            }
        });
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("claim", Collections.singletonMap("test", "value"), new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"claim", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Reserved", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)wi.getResults().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", wi.getResults().get("test"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", wi.getResults().get("ActorId"));
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.abort();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(3);
        Assertions.assertThat(workItemTransitionEvents).hasSize(10);
    }

    @Test
    public void testBasicUserTaskProcessClaimAndCompleteWrongUser() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        String wiId = wi.getId();
        StaticIdentityProvider identity = new StaticIdentityProvider("kelly");
        List securedWorkItems = processInstance.workItems(new Policy[]{SecurityPolicy.of((IdentityProvider)identity)});
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)securedWorkItems.size());
        org.junit.jupiter.api.Assertions.assertThrows(WorkItemNotFoundException.class, () -> UserTaskTest.lambda$testBasicUserTaskProcessClaimAndCompleteWrongUser$1(processInstance, wiId, (IdentityProvider)identity));
        org.junit.jupiter.api.Assertions.assertThrows(NotAuthorizedException.class, () -> UserTaskTest.lambda$testBasicUserTaskProcessClaimAndCompleteWrongUser$2(processInstance, wiId, (IdentityProvider)identity));
        org.junit.jupiter.api.Assertions.assertThrows(NotAuthorizedException.class, () -> UserTaskTest.lambda$testBasicUserTaskProcessClaimAndCompleteWrongUser$3(processInstance, wiId, (IdentityProvider)identity));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        StaticIdentityProvider identityCorrect = new StaticIdentityProvider("john");
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, (IdentityProvider)identityCorrect));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.abort();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(3);
    }

    @Test
    public void testApprovalWithExcludedOwnerViaPhases() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/approval.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("approvals");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        StaticIdentityProvider identity = new StaticIdentityProvider("admin", Collections.singletonList("managers"));
        SecurityPolicy policy = SecurityPolicy.of((IdentityProvider)identity);
        processInstance.workItems(new Policy[]{policy});
        List workItems = processInstance.workItems(new Policy[]{policy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        HumanTaskTransition transition = new HumanTaskTransition("complete", null, (IdentityProvider)identity);
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)transition);
        workItems = processInstance.workItems(new Policy[]{policy});
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)workItems.size());
        identity = new StaticIdentityProvider("john", Collections.singletonList("managers"));
        policy = SecurityPolicy.of((IdentityProvider)identity);
        workItems = processInstance.workItems(new Policy[]{policy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        transition = new HumanTaskTransition("complete", null, (IdentityProvider)identity);
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)transition);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testApprovalWithExcludedOwner() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/approval.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("approvals");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        StaticIdentityProvider identity = new StaticIdentityProvider("admin", Collections.singletonList("managers"));
        SecurityPolicy policy = SecurityPolicy.of((IdentityProvider)identity);
        processInstance.workItems(new Policy[]{policy});
        List workItems = processInstance.workItems(new Policy[]{policy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{policy});
        workItems = processInstance.workItems(new Policy[]{policy});
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)workItems.size());
        identity = new StaticIdentityProvider("john", Collections.singletonList("managers"));
        policy = SecurityPolicy.of((IdentityProvider)identity);
        workItems = processInstance.workItems(new Policy[]{policy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[]{policy});
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testRESTApiForUserTasks() throws Exception {
        Method[] methods;
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Class<?> resourceClazz = Class.forName("org.kie.kogito.test.UserTasksProcessResource", true, this.testClassLoader());
        org.junit.jupiter.api.Assertions.assertNotNull(resourceClazz);
        LinkedHashSet<String> completeTaskPaths = new LinkedHashSet<String>();
        for (Method m : methods = resourceClazz.getMethods()) {
            Annotation[] annotations;
            if (!m.getName().startsWith("completeTask")) continue;
            for (Annotation annotation : annotations = m.getAnnotations()) {
                if (!annotation.annotationType().getSimpleName().equals("Path")) continue;
                completeTaskPaths.add(annotation.toString().replaceAll("\\\"", ""));
            }
        }
        ((IterableAssert)Assertions.assertThat(completeTaskPaths).hasSize(2)).containsOnly((Object[])new String[]{"@javax.ws.rs.Path(value=/{id}/FirstTask/{workItemId})", "@javax.ws.rs.Path(value=/{id}/SecondTask/{workItemId})"});
    }

    @Test
    public void testBasicUserTaskProcessCancelAndTriggerNode() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        String firstSecondTaskNodeInstanceId = wi.getNodeInstanceId();
        processInstance.cancelNodeInstance(wi.getNodeInstanceId());
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.triggerNode("UserTask_2");
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)firstSecondTaskNodeInstanceId, (Object)wi.getNodeInstanceId());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testBasicUserTaskProcessCancelAndRetriggerNode() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        String firstSecondTaskNodeInstanceId = wi.getNodeInstanceId();
        processInstance.retriggerNodeInstance(wi.getNodeInstanceId());
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)firstSecondTaskNodeInstanceId, (Object)wi.getNodeInstanceId());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testBasicUserTaskProcessClaimReleaseClaimAndCompletePhases() throws Exception {
        Application app = this.generateCodeProcessesOnly("usertask/UserTasksProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("UserTasksProcess");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        WorkItem wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("claim", Collections.singletonMap("test", "value"), new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"claim", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Reserved", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)wi.getResults().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", wi.getResults().get("test"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", wi.getResults().get("ActorId"));
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("release", null, new Policy[]{this.securityPolicy}));
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"release", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)wi.getResults().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", wi.getResults().get("test"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", wi.getResults().get("ActorId"));
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("claim", Collections.singletonMap("test", "value"), new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FirstTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"claim", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Reserved", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)wi.getResults().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", wi.getResults().get("test"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", wi.getResults().get("ActorId"));
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", null, new Policy[]{this.securityPolicy}));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        wi = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SecondTask", (Object)wi.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"active", (Object)wi.getPhase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ready", (Object)wi.getPhaseStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)wi.getResults().size());
        processInstance.abort();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(3);
    }

    private static /* synthetic */ void lambda$testBasicUserTaskProcessClaimAndCompleteWrongUser$3(ProcessInstance processInstance, String wiId, IdentityProvider identity) throws Throwable {
        processInstance.completeWorkItem(wiId, null, new Policy[]{SecurityPolicy.of((IdentityProvider)identity)});
    }

    private static /* synthetic */ void lambda$testBasicUserTaskProcessClaimAndCompleteWrongUser$2(ProcessInstance processInstance, String wiId, IdentityProvider identity) throws Throwable {
        processInstance.transitionWorkItem(wiId, (Transition)new HumanTaskTransition("claim", null, identity));
    }

    private static /* synthetic */ void lambda$testBasicUserTaskProcessClaimAndCompleteWrongUser$1(ProcessInstance processInstance, String wiId, IdentityProvider identity) throws Throwable {
        processInstance.workItem(wiId, new Policy[]{SecurityPolicy.of((IdentityProvider)identity)});
    }
}

