/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.Sig;

public class GatewayTest
extends AbstractCodegenTest {
    @Test
    public void testEventBasedGatewayWithData() throws Exception {
        Application app = this.generateCode(Collections.singletonList("gateway/EventBasedSplit.bpmn2"), Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Assertions.assertThat((Object)app).isNotNull();
        Process p = app.processes().processById("EventBasedSplit");
        Model m = (Model)p.createModel();
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.send(Sig.of((String)"First", (Object)"test"));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"x");
        Assertions.assertThat(result.toMap().get("x")).isEqualTo((Object)"test");
        Assertions.assertThat((Iterable)p.instances().values()).hasSize(0);
        processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.send(Sig.of((String)"Second", (Object)"value"));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"x");
        Assertions.assertThat(result.toMap().get("x")).isEqualTo((Object)"value");
        Assertions.assertThat((Iterable)p.instances().values()).hasSize(0);
    }
}

