/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.decision;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.AddonsConfig;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.GeneratorContext;
import org.kie.kogito.codegen.decision.DecisionCodegen;
import org.kie.kogito.codegen.io.CollectedResource;
import org.kie.kogito.grafana.JGrafana;

public class DecisionCodegenTest {
    @Test
    public void generateAllFiles() throws Exception {
        GeneratorContext context = this.stronglyTypedContext();
        DecisionCodegen codeGenerator = DecisionCodegen.ofCollectedResources((Collection)CollectedResource.fromPaths((Path[])new Path[]{Paths.get("src/test/resources/decision/models/vacationDays", new String[0]).toAbsolutePath()}));
        codeGenerator.setContext(context);
        List generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(6);
        Assertions.assertThat(this.fileNames(generatedFiles)).containsAll(Arrays.asList("decision/InputSet.java", "decision/OutputSet.java", "decision/TEmployee.java", "decision/TAddress.java", "decision/TPayroll.java", "decision/VacationsResource.java", "org/kie/kogito/app/DecisionModelResourcesProvider.java"));
        ClassOrInterfaceDeclaration classDeclaration = codeGenerator.section().classDeclaration();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)classDeclaration);
    }

    private GeneratorContext stronglyTypedContext() {
        Properties properties = new Properties();
        properties.put(DecisionCodegen.STRONGLY_TYPED_CONFIGURATION_KEY, Boolean.TRUE.toString());
        return GeneratorContext.ofProperties((Properties)properties);
    }

    private List<String> fileNames(List<GeneratedFile> generatedFiles) {
        return generatedFiles.stream().map(GeneratedFile::relativePath).collect(Collectors.toList());
    }

    @Test
    public void doNotGenerateTypesafeInfo() throws Exception {
        GeneratorContext context = this.stronglyTypedContext();
        DecisionCodegen codeGenerator = DecisionCodegen.ofCollectedResources((Collection)CollectedResource.fromPaths((Path[])new Path[]{Paths.get("src/test/resources/decision/alltypes/", new String[0]).toAbsolutePath()}));
        codeGenerator.setContext(context);
        List generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(3);
        Assertions.assertThat(this.fileNames(generatedFiles)).containsAll(Arrays.asList("http_58_47_47www_46trisotech_46com_47definitions_47__4f5608e9_454d74_454c22_45a47e_45ab657257fc9c/InputSet.java", "http_58_47_47www_46trisotech_46com_47definitions_47__4f5608e9_454d74_454c22_45a47e_45ab657257fc9c/OutputSet.java", "http_58_47_47www_46trisotech_46com_47definitions_47__4f5608e9_454d74_454c22_45a47e_45ab657257fc9c/OneOfEachTypeResource.java", "org/kie/kogito/app/DecisionModelResourcesProvider.java"));
        ClassOrInterfaceDeclaration classDeclaration = codeGenerator.section().classDeclaration();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)classDeclaration);
    }

    @Test
    public void givenADMNModelWhenMonitoringIsActiveThenGrafanaDashboardsAreGenerated() throws Exception {
        List<GeneratedFile> dashboards = this.generateTestDashboards(new AddonsConfig().withMonitoring(true));
        JGrafana vacationOperationalDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("operational-dashboard-Vacations.json")).findFirst().get().contents()));
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)vacationOperationalDashboard.getDashboard().panels.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)vacationOperationalDashboard.getDashboard().links.size());
        JGrafana vacationDomainDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("domain-dashboard-Vacations.json")).findFirst().get().contents()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)vacationDomainDashboard.getDashboard().panels.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)vacationDomainDashboard.getDashboard().links.size());
    }

    @Test
    public void givenADMNModelWhenMonitoringAndTracingAreActiveThenTheGrafanaDashboardsContainsTheAuditUILink() throws Exception {
        List<GeneratedFile> dashboards = this.generateTestDashboards(new AddonsConfig().withMonitoring(true).withTracing(true));
        JGrafana vacationOperationalDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("operational-dashboard-Vacations.json")).findFirst().get().contents()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)vacationOperationalDashboard.getDashboard().links.size());
        JGrafana vacationDomainDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("domain-dashboard-Vacations.json")).findFirst().get().contents()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)vacationDomainDashboard.getDashboard().links.size());
    }

    @Test
    public void resilientToDuplicateDMNIDs() throws Exception {
        DecisionCodegen codeGenerator = DecisionCodegen.ofCollectedResources((Collection)CollectedResource.fromPaths((Path[])new Path[]{Paths.get("src/test/resources/decision-test20200507", new String[0]).toAbsolutePath()}));
        List generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(3);
        ClassOrInterfaceDeclaration classDeclaration = codeGenerator.section().classDeclaration();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)classDeclaration);
    }

    @Test
    public void emptyName() throws Exception {
        DecisionCodegen codeGenerator = DecisionCodegen.ofCollectedResources((Collection)CollectedResource.fromPaths((Path[])new Path[]{Paths.get("src/test/resources/decision-empty-name", new String[0]).toAbsolutePath()}));
        RuntimeException re = (RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> codeGenerator.generate());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Model name should not be empty", (Object)re.getMessage());
    }

    private List<GeneratedFile> generateTestDashboards(AddonsConfig addonsConfig) throws IOException {
        DecisionCodegen codeGenerator = DecisionCodegen.ofCollectedResources((Collection)CollectedResource.fromPaths((Path[])new Path[]{Paths.get("src/test/resources/decision/models/vacationDays", new String[0]).toAbsolutePath()})).withAddons(addonsConfig);
        List generatedFiles = codeGenerator.generate();
        List<GeneratedFile> dashboards = generatedFiles.stream().filter(x -> x.getType() == GeneratedFile.Type.RESOURCE).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)dashboards.size());
        List staticDashboards = generatedFiles.stream().filter(x -> x.getType() == GeneratedFile.Type.GENERATED_CP_RESOURCE && x.relativePath().contains("dashboard")).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)staticDashboards.size());
        return dashboards;
    }

    @Test
    public void testNSEW_positive() throws Exception {
        DecisionCodegen codeGenerator = DecisionCodegen.ofCollectedResources((Collection)CollectedResource.fromPaths((Path[])new Path[]{Paths.get("src/test/resources/decision-NSEW", new String[0]).toAbsolutePath()}));
        GeneratorContext context = this.stronglyTypedContext();
        codeGenerator.setContext(context);
        codeGenerator.withClassLoader(new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return Object.class;
            }
        });
        List generatedFiles = codeGenerator.generate();
        Assertions.assertThat((List)generatedFiles).anyMatch(x -> x.relativePath().endsWith("InputSet.java"));
        GeneratedFile inputSetFile = generatedFiles.stream().filter(x -> x.relativePath().endsWith("InputSet.java")).findFirst().get();
        Assertions.assertThat((String)new String(inputSetFile.contents())).containsPattern((CharSequence)"@org\\.eclipse\\.microprofile\\.openapi\\.annotations\\.media\\.Schema\\(.*enumeration");
    }

    @Test
    public void testNSEW_negative() throws Exception {
        DecisionCodegen codeGenerator = DecisionCodegen.ofCollectedResources((Collection)CollectedResource.fromPaths((Path[])new Path[]{Paths.get("src/test/resources/decision-NSEW", new String[0]).toAbsolutePath()}));
        GeneratorContext context = this.stronglyTypedContext();
        codeGenerator.setContext(context);
        List generatedFiles = codeGenerator.generate();
        Assertions.assertThat((List)generatedFiles).anyMatch(x -> x.relativePath().endsWith("InputSet.java"));
        GeneratedFile inputSetFile = generatedFiles.stream().filter(x -> x.relativePath().endsWith("InputSet.java")).findFirst().get();
        Assertions.assertThat((String)new String(inputSetFile.contents())).doesNotContain(new CharSequence[]{"@org.eclipse.microprofile.openapi.annotations.media.Schema"});
    }
}

