/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.prediction;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.AddonsConfig;
import org.kie.kogito.codegen.prediction.PMMLResource;
import org.kie.kogito.codegen.prediction.PredictionModelsGenerator;
import org.kie.pmml.commons.model.KiePMMLModel;

class PredictionContainerGeneratorTest {
    private static final String APP_CANONICAL_NAME = "APP_CANONICAL_NAME";
    private static final List<PMMLResource> PMML_RESOURCES = PredictionContainerGeneratorTest.getPMMLResources();
    private static PredictionModelsGenerator predictionContainerGenerator;

    PredictionContainerGeneratorTest() {
    }

    @BeforeAll
    public static void setup() {
        predictionContainerGenerator = new PredictionModelsGenerator(APP_CANONICAL_NAME, PMML_RESOURCES);
        Assertions.assertNotNull((Object)predictionContainerGenerator);
    }

    @Test
    void constructor() {
        Assertions.assertEquals((Object)APP_CANONICAL_NAME, (Object)PredictionContainerGeneratorTest.predictionContainerGenerator.applicationCanonicalName);
        Assertions.assertEquals(PMML_RESOURCES, (Object)PredictionContainerGeneratorTest.predictionContainerGenerator.resources);
    }

    @Test
    void withAddons() {
        PredictionModelsGenerator retrieved = predictionContainerGenerator.withAddons(null);
        Assertions.assertEquals((Object)retrieved, (Object)predictionContainerGenerator);
        Assertions.assertNull((Object)PredictionContainerGeneratorTest.predictionContainerGenerator.addonsConfig);
        predictionContainerGenerator.withAddons(AddonsConfig.DEFAULT);
        Assertions.assertEquals((Object)AddonsConfig.DEFAULT, (Object)PredictionContainerGeneratorTest.predictionContainerGenerator.addonsConfig);
    }

    @Test
    void classDeclaration() {
        ClassOrInterfaceDeclaration retrieved = predictionContainerGenerator.classDeclaration();
        Assertions.assertNotNull((Object)retrieved);
        String retrievedString = retrieved.toString();
        String expected = PMML_RESOURCES.stream().map(pmmlResource -> "\"" + pmmlResource.getModelPath() + "\"").collect(Collectors.joining(", "));
        expected = String.format("org.kie.kogito.pmml.PMMLKogito.createKieRuntimeFactories(%s);", expected);
        Assertions.assertTrue((boolean)retrievedString.contains(expected));
    }

    private static List<PMMLResource> getPMMLResources() {
        return IntStream.range(0, 3).mapToObj(i -> PredictionContainerGeneratorTest.getPMMLResource("Resource-" + i)).collect(Collectors.toList());
    }

    private static PMMLResource getPMMLResource(String resourceName) {
        Path path = PredictionContainerGeneratorTest.getPath();
        String modelPath = "path/to/" + resourceName;
        List kiePmmlModels = IntStream.range(0, 3).mapToObj(i -> PredictionContainerGeneratorTest.getKiePMMLModelInternal(resourceName + "_Model-" + i)).collect(Collectors.toList());
        return new PMMLResource(kiePmmlModels, path, modelPath);
    }

    private static KiePMMLModel getKiePMMLModelInternal(String modelName) {
        return new KiePMMLModel(modelName, Collections.emptyList()){

            public Object evaluate(Object o, Map<String, Object> map) {
                return null;
            }
        };
    }

    private static Path getPath() {
        return new Path(){

            @Override
            public FileSystem getFileSystem() {
                return null;
            }

            @Override
            public boolean isAbsolute() {
                return false;
            }

            @Override
            public Path getRoot() {
                return null;
            }

            @Override
            public Path getFileName() {
                return null;
            }

            @Override
            public Path getParent() {
                return null;
            }

            @Override
            public int getNameCount() {
                return 0;
            }

            @Override
            public Path getName(int index) {
                return null;
            }

            @Override
            public Path subpath(int beginIndex, int endIndex) {
                return null;
            }

            @Override
            public boolean startsWith(Path other) {
                return false;
            }

            @Override
            public boolean endsWith(Path other) {
                return false;
            }

            @Override
            public Path normalize() {
                return null;
            }

            @Override
            public Path resolve(Path other) {
                return null;
            }

            @Override
            public Path relativize(Path other) {
                return null;
            }

            @Override
            public URI toUri() {
                return null;
            }

            @Override
            public Path toAbsolutePath() {
                return null;
            }

            @Override
            public Path toRealPath(LinkOption ... options) throws IOException {
                return null;
            }

            @Override
            public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
                return null;
            }

            @Override
            public int compareTo(Path other) {
                return 0;
            }

            @Override
            public Iterator<Path> iterator() {
                return null;
            }

            @Override
            public boolean startsWith(String other) {
                return false;
            }

            @Override
            public boolean endsWith(String other) {
                return false;
            }

            @Override
            public Path resolve(String other) {
                return null;
            }

            @Override
            public Path resolveSibling(Path other) {
                return null;
            }

            @Override
            public Path resolveSibling(String other) {
                return null;
            }

            @Override
            public File toFile() {
                return null;
            }

            @Override
            public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
                return null;
            }
        };
    }
}

