/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.prediction.config;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.di.CDIDependencyInjectionAnnotator;
import org.kie.kogito.codegen.di.DependencyInjectionAnnotator;
import org.kie.kogito.codegen.di.SpringDependencyInjectionAnnotator;
import org.kie.kogito.codegen.prediction.config.PredictionConfigGenerator;

class PredictionConfigGeneratorTest {
    private static final String PACKAGE_NAME = "PACKAGENAME";
    private static PredictionConfigGenerator predictionConfigGenerator;

    PredictionConfigGeneratorTest() {
    }

    @BeforeAll
    public static void setup() {
        predictionConfigGenerator = new PredictionConfigGenerator(PACKAGE_NAME);
        Assertions.assertNotNull((Object)predictionConfigGenerator);
    }

    @Test
    void compilationUnitWithCDI() {
        predictionConfigGenerator.withDependencyInjection((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator());
        Optional retrievedOpt = predictionConfigGenerator.compilationUnit();
        Assertions.assertTrue((boolean)retrievedOpt.isPresent());
        String retrieved = ((CompilationUnit)retrievedOpt.get()).toString();
        String expected = "@javax.inject.Singleton";
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        expected = "@javax.inject.Inject";
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        String unexpected = "@org.springframework.stereotype.Component";
        Assertions.assertFalse((boolean)retrieved.contains(unexpected));
        unexpected = "@org.springframework.beans.factory.annotation.Autowired";
        Assertions.assertFalse((boolean)retrieved.contains(unexpected));
    }

    @Test
    void compilationUnitWithSpring() {
        predictionConfigGenerator.withDependencyInjection((DependencyInjectionAnnotator)new SpringDependencyInjectionAnnotator());
        Optional retrievedOpt = predictionConfigGenerator.compilationUnit();
        Assertions.assertTrue((boolean)retrievedOpt.isPresent());
        String retrieved = ((CompilationUnit)retrievedOpt.get()).toString();
        String expected = "@org.springframework.stereotype.Component";
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        expected = "@org.springframework.beans.factory.annotation.Autowired";
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        String unexpected = "@javax.inject.Singleton";
        Assertions.assertFalse((boolean)retrieved.contains(unexpected));
        unexpected = "@javax.inject.Inject";
        Assertions.assertFalse((boolean)retrieved.contains(unexpected));
    }

    @Test
    void newInstance() {
        ObjectCreationExpr retrieved = predictionConfigGenerator.newInstance();
        String expected = "new org.kie.kogito.pmml.config.StaticPredictionConfig()";
        Assertions.assertEquals((Object)expected, (Object)retrieved.toString());
    }

    @Test
    void members() {
        List retrieved = predictionConfigGenerator.members();
        Assertions.assertNotNull((Object)retrieved);
        Assertions.assertTrue((boolean)retrieved.isEmpty());
    }
}

