/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.events;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.AddonsConfig;
import org.kie.kogito.codegen.di.CDIDependencyInjectionAnnotator;
import org.kie.kogito.codegen.di.DependencyInjectionAnnotator;
import org.kie.kogito.codegen.process.ProcessGenerationUtils;
import org.kie.kogito.codegen.process.events.TopicsInformationResourceGenerator;
import org.kie.kogito.event.EventKind;

class TopicsInformationResourceGeneratorTest {
    TopicsInformationResourceGeneratorTest() {
    }

    @Test
    void verifyProcessWithMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/messageevent/IntermediateCatchEventMessage.bpmn2", 1, true);
        Assertions.assertThat((Object)clazz).isNotNull();
        Assertions.assertThat((Optional)clazz.getDefaultConstructor()).isPresent();
        Assertions.assertThat((List)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatements()).hasSize(2);
        Assertions.assertThat((String)((ExpressionStmt)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatement(1).toExpressionStmt().get()).getExpression().toString()).contains(new CharSequence[]{"customer"});
    }

    @Test
    void verifyProcessWithMessageEventNoInjection() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/messageevent/IntermediateCatchEventMessage.bpmn2", 1, false);
        Assertions.assertThat((Object)clazz).isNotNull();
        Assertions.assertThat((Optional)((BlockStmt)((MethodDeclaration)clazz.findFirst(MethodDeclaration.class, md -> md.getName().toString().equals("getTopics")).get()).getBody().get()).findFirst(BlockStmt.class, b -> ((Statement)b.getStatements().get(0)).asExpressionStmt().getExpression().toString().contains("NoOpTopicDiscovery"))).isPresent();
    }

    @Test
    void verifyProcessWithStartAndEndMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/messagestartevent/MessageStartAndEndEvent.bpmn2", 2, true);
        Assertions.assertThat((Object)clazz).isNotNull();
        Assertions.assertThat((Optional)clazz.getDefaultConstructor()).isPresent();
        Assertions.assertThat((List)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatements()).hasSize(3);
        ((AbstractStringAssert)Assertions.assertThat((String)((ExpressionStmt)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatement(1).toExpressionStmt().get()).getExpression().toString()).contains(new CharSequence[]{"customers"})).contains(new CharSequence[]{EventKind.CONSUMED.name()});
        ((AbstractStringAssert)Assertions.assertThat((String)((ExpressionStmt)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatement(2).toExpressionStmt().get()).getExpression().toString()).contains(new CharSequence[]{"processedcustomers"})).contains(new CharSequence[]{EventKind.PRODUCED.name()});
    }

    @Test
    void verifyProcessWithIntermediateThrowEventMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/messageevent/IntermediateThrowEventMessage.bpmn2", 1, true);
        Assertions.assertThat((Object)clazz).isNotNull();
        Assertions.assertThat((Optional)clazz.getDefaultConstructor()).isPresent();
        Assertions.assertThat((List)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatements()).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)((ExpressionStmt)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatement(1).toExpressionStmt().get()).getExpression().toString()).contains(new CharSequence[]{"customers"})).contains(new CharSequence[]{EventKind.PRODUCED.name()});
    }

    @Test
    void verifyProcessWithBoundaryEventMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/messageevent/BoundaryMessageEventOnTask.bpmn2", 1, true);
        Assertions.assertThat((Object)clazz).isNotNull();
        Assertions.assertThat((Optional)clazz.getDefaultConstructor()).isPresent();
        Assertions.assertThat((List)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatements()).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)((ExpressionStmt)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatement(1).toExpressionStmt().get()).getExpression().toString()).contains(new CharSequence[]{"customers"})).contains(new CharSequence[]{EventKind.CONSUMED.name()});
    }

    @Test
    void verifyProcessWithoutMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/usertask/approval.bpmn2", 0, true);
        Assertions.assertThat((Object)clazz).isNotNull();
        Assertions.assertThat((Optional)clazz.getDefaultConstructor()).isPresent();
        Assertions.assertThat((List)((ConstructorDeclaration)clazz.getDefaultConstructor().get()).getBody().getStatements()).hasSize(1);
    }

    private ClassOrInterfaceDeclaration generateAndParseClass(String bpmnFile, int expectedTriggers, boolean withInjection) {
        CDIDependencyInjectionAnnotator annotator = null;
        if (withInjection) {
            annotator = new CDIDependencyInjectionAnnotator();
        }
        TopicsInformationResourceGenerator generator = new TopicsInformationResourceGenerator(ProcessGenerationUtils.execModelFromProcessFile(bpmnFile), (DependencyInjectionAnnotator)annotator, AddonsConfig.DEFAULT.withCloudEvents(true));
        if (expectedTriggers > 0) {
            Assertions.assertThat((Map)generator.getTriggers()).isNotEmpty();
            int triggersCount = 0;
            for (Map.Entry entry : generator.getTriggers().entrySet()) {
                triggersCount += ((List)entry.getValue()).size();
            }
            Assertions.assertThat((int)triggersCount).isEqualTo(expectedTriggers);
        } else {
            Assertions.assertThat((Map)generator.getTriggers()).isEmpty();
        }
        String source = generator.generate();
        Assertions.assertThat((String)source).isNotNull();
        ClassOrInterfaceDeclaration clazz = (ClassOrInterfaceDeclaration)StaticJavaParser.parse((String)source).getClassByName(generator.getClassName()).orElseThrow(() -> new IllegalArgumentException("Class does not exists"));
        return clazz;
    }
}

